/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.path;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opentripplanner.framework.collection.CompositeComparator;
import org.opentripplanner.framework.text.Table;
import org.opentripplanner.framework.text.TableBuilder;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.routing.util.DiffEntry;
import org.opentripplanner.routing.util.DiffTool;

public class PathDiff<T extends RaptorTripSchedule> {
    public final RaptorPath<T> path;
    public final Integer walkDuration;
    public final List<String> routes = new ArrayList<String>();
    public final List<Integer> stops = new ArrayList<Integer>();

    private PathDiff(RaptorPath<T> path) {
        this.path = path;
        this.walkDuration = path.legStream().filter(PathLeg::isTransferLeg).mapToInt(l -> l.asTransferLeg().duration()).sum();
        this.routes.addAll(path.transitLegs().map(l -> l.trip().pattern().debugInfo()).collect(Collectors.toList()));
        this.stops.addAll(path.listStops());
    }

    public static <T extends RaptorTripSchedule> void logDiff(String leftLabel, Collection<? extends RaptorPath<T>> left, String rightLabel, Collection<? extends RaptorPath<T>> right, boolean skipCost, boolean skipEquals, Consumer<String> logger) {
        List<DiffEntry<PathDiff<T>>> result = PathDiff.diff(left, right, skipCost);
        TableBuilder tbl = Table.of().withAlights(Table.Align.Center, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Left).withHeaders("STATUS", "TX", "Duration", "Cost", "Walk", "Start", "End", "Path");
        for (DiffEntry<PathDiff<T>> e : result) {
            if (skipEquals && e.isEqual()) continue;
            PathDiff<T> it = e.element();
            tbl.addRow(e.status("EQ", "DROPPED", "NEW"), it.path.numberOfTransfers(), DurationUtils.durationToStr(it.path.durationInSeconds()), it.path.c1(), DurationUtils.durationToStr(it.walkDuration), TimeUtils.timeToStrCompact(it.path.startTime()), TimeUtils.timeToStrCompact(it.path.endTime()), it.path.toString());
        }
        logger.accept("Compare " + leftLabel + " with " + rightLabel + "\n" + tbl.toString());
    }

    public static <T extends RaptorTripSchedule> List<DiffEntry<PathDiff<T>>> diff(Collection<? extends RaptorPath<T>> left, Collection<? extends RaptorPath<T>> right, boolean skipCost) {
        return DiffTool.diff(left.stream().map(PathDiff::new).collect(Collectors.toList()), right.stream().map(PathDiff::new).collect(Collectors.toList()), PathDiff.comparator(skipCost));
    }

    public static <T extends RaptorTripSchedule> Comparator<PathDiff<T>> comparator(boolean skipCost) {
        return new CompositeComparator<PathDiff<T>>(Comparator.comparingInt(o -> o.path.endTime()), Comparator.comparingInt(o -> -o.path.startTime()), Comparator.comparingInt(o -> skipCost ? 0 : -o.path.c1()), (o1, o2) -> PathDiff.compareLists(o1.routes, o2.routes, String::compareTo), (o1, o2) -> PathDiff.compareLists(o1.stops, o2.stops, Integer::compareTo));
    }

    private static <T> int compareLists(List<T> a, List<T> b, Comparator<T> comparator) {
        int size = Math.min(a.size(), b.size());
        for (int i = 0; i < size; ++i) {
            int c = comparator.compare(a.get(i), b.get(i));
            if (c == 0) continue;
            return c;
        }
        return a.size() - b.size();
    }
}

