/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.mapping;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.plan.FrequencyTransitLeg;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.UnknownTransitPathLeg;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.TransferPathLeg;
import org.opentripplanner.raptor.api.path.TransitPathLeg;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultRaptorTransfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.RaptorCostConverter;
import org.opentripplanner.routing.algorithm.transferoptimization.api.OptimizedPath;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.request.StreetSearchRequestMapper;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public class RaptorPathToItineraryMapper<T extends TripSchedule> {
    private final TransitLayer transitLayer;
    private final RouteRequest request;
    private final StreetSearchRequest transferStreetRequest;
    private final StreetMode transferMode;
    private final ZonedDateTime transitSearchTimeZero;
    private final GraphPathToItineraryMapper graphPathToItineraryMapper;

    public RaptorPathToItineraryMapper(Graph graph, TransitService transitService, TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero, RouteRequest request) {
        this.transitLayer = transitLayer;
        this.transitSearchTimeZero = transitSearchTimeZero;
        this.transferMode = request.journey().transfer().mode();
        this.request = request;
        this.transferStreetRequest = StreetSearchRequestMapper.mapToTransferRequest(request).build();
        this.graphPathToItineraryMapper = new GraphPathToItineraryMapper(transitService.getTimeZone(), graph.streetNotesService, graph.ellipsoidToGeoidDifference);
    }

    public Itinerary createItinerary(RaptorPath<T> path) {
        if (path.isUnknownPath()) {
            return this.mapDirectPath(path);
        }
        OptimizedPath optimizedPath = path instanceof OptimizedPath ? (OptimizedPath)path : null;
        ArrayList<Leg> legs = new ArrayList<Leg>(this.mapAccessLeg(path.accessLeg()));
        PathLeg<T> pathLeg = path.accessLeg().nextLeg();
        Leg transitLeg = null;
        while (!pathLeg.isEgressLeg()) {
            if (pathLeg.isTransitLeg()) {
                transitLeg = this.mapTransitLeg(transitLeg, pathLeg.asTransitLeg());
                legs.add(transitLeg);
            } else if (pathLeg.isTransferLeg()) {
                legs.addAll(this.mapTransferLeg(pathLeg.asTransferLeg(), this.transferMode == StreetMode.BIKE ? TraverseMode.BICYCLE : TraverseMode.WALK));
            }
            pathLeg = pathLeg.nextLeg();
        }
        EgressPathLeg<T> egressPathLeg = pathLeg.asEgressLeg();
        Itinerary mapped = this.mapEgressLeg(egressPathLeg);
        legs.addAll(mapped == null ? List.of() : mapped.getLegs());
        Itinerary itinerary = new Itinerary(legs);
        itinerary.setGeneralizedCost(RaptorCostConverter.toOtpDomainCost(path.c1()));
        itinerary.setArrivedAtDestinationWithRentedVehicle(mapped != null && mapped.isArrivedAtDestinationWithRentedVehicle());
        if (optimizedPath != null) {
            itinerary.setWaitTimeOptimizedCost(RaptorCostConverter.toOtpDomainCost(optimizedPath.generalizedCostWaitTimeOptimized()));
            itinerary.setTransferPriorityCost(RaptorCostConverter.toOtpDomainCost(optimizedPath.transferPriorityCost()));
        }
        return itinerary;
    }

    private List<Leg> mapAccessLeg(AccessPathLeg<T> accessPathLeg) {
        if (accessPathLeg.access().isFree()) {
            return List.of();
        }
        DefaultAccessEgress accessPath = (DefaultAccessEgress)accessPathLeg.access();
        GraphPath<State, Edge, Vertex> graphPath = new GraphPath<State, Edge, Vertex>(accessPath.getLastState());
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.getLegs().isEmpty()) {
            return List.of();
        }
        return subItinerary.withTimeShiftToStartAt(this.createZonedDateTime(accessPathLeg.fromTime())).getLegs();
    }

    private Leg mapTransitLeg(Leg prevTransitLeg, TransitPathLeg<T> pathLeg) {
        TripSchedule tripSchedule = (TripSchedule)pathLeg.trip();
        int lastLegCost = 0;
        PathLeg<T> nextLeg = pathLeg.nextLeg();
        if (nextLeg.isEgressLeg() && this.isFree(nextLeg.asEgressLeg())) {
            lastLegCost = pathLeg.nextLeg().generalizedCost();
        }
        int boardStopIndexInPattern = tripSchedule.findDepartureStopPosition(pathLeg.fromTime(), pathLeg.fromStop());
        int alightStopIndexInPattern = tripSchedule.findArrivalStopPosition(pathLeg.toTime(), pathLeg.toStop());
        if (tripSchedule.isFrequencyBasedTrip()) {
            int frequencyHeadwayInSeconds = tripSchedule.frequencyHeadwayInSeconds();
            return new FrequencyTransitLeg(tripSchedule.getOriginalTripTimes(), tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern, this.createZonedDateTime(pathLeg.fromTime() + frequencyHeadwayInSeconds), this.createZonedDateTime(pathLeg.toTime()), tripSchedule.getServiceDate(), this.transitSearchTimeZero.getZone().normalized(), prevTransitLeg == null ? null : prevTransitLeg.getTransferToNextLeg(), (ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg(), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost() + lastLegCost), frequencyHeadwayInSeconds, null);
        }
        return new ScheduledTransitLeg(tripSchedule.getOriginalTripTimes(), tripSchedule.getOriginalTripPattern(), boardStopIndexInPattern, alightStopIndexInPattern, this.createZonedDateTime(pathLeg.fromTime()), this.createZonedDateTime(pathLeg.toTime()), tripSchedule.getServiceDate(), this.transitSearchTimeZero.getZone().normalized(), prevTransitLeg == null ? null : prevTransitLeg.getTransferToNextLeg(), (ConstrainedTransfer)pathLeg.getConstrainedTransferAfterLeg(), RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost() + lastLegCost), null);
    }

    private boolean isFree(EgressPathLeg<T> egressPathLeg) {
        return egressPathLeg.egress().isFree();
    }

    private List<Leg> mapTransferLeg(TransferPathLeg<T> pathLeg, TraverseMode transferMode) {
        StopLocation transferFromStop = this.transitLayer.getStopByIndex(pathLeg.fromStop());
        StopLocation transferToStop = this.transitLayer.getStopByIndex(pathLeg.toStop());
        Transfer transfer = ((DefaultRaptorTransfer)pathLeg.transfer()).transfer();
        Place from = Place.forStop(transferFromStop);
        Place to = Place.forStop(transferToStop);
        return this.mapNonTransitLeg(pathLeg, transfer, transferMode, from, to);
    }

    private Itinerary mapEgressLeg(EgressPathLeg<T> egressPathLeg) {
        if (this.isFree(egressPathLeg)) {
            return null;
        }
        DefaultAccessEgress egressPath = (DefaultAccessEgress)egressPathLeg.egress();
        GraphPath<State, Edge, Vertex> graphPath = new GraphPath<State, Edge, Vertex>(egressPath.getLastState());
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.getLegs().isEmpty()) {
            return null;
        }
        return subItinerary.withTimeShiftToStartAt(this.createZonedDateTime(egressPathLeg.fromTime()));
    }

    private List<Leg> mapNonTransitLeg(PathLeg<T> pathLeg, Transfer transfer, TraverseMode transferMode, Place from, Place to) {
        List<Edge> edges = transfer.getEdges();
        if (edges == null || edges.isEmpty()) {
            return List.of(StreetLeg.create().withMode(transferMode).withStartTime(this.createZonedDateTime(pathLeg.fromTime())).withEndTime(this.createZonedDateTime(pathLeg.toTime())).withFrom(from).withTo(to).withDistanceMeters(transfer.getDistanceMeters()).withGeneralizedCost(RaptorCostConverter.toOtpDomainCost(pathLeg.generalizedCost())).withGeometry(GeometryUtils.makeLineString(transfer.getCoordinates())).withWalkSteps(List.of()).build());
        }
        StateEditor se = new StateEditor(edges.get(0).getFromVertex(), this.transferStreetRequest);
        se.setTimeSeconds(this.createZonedDateTime(pathLeg.fromTime()).toEpochSecond());
        State s = se.makeState();
        ArrayList<State> transferStates = new ArrayList<State>();
        transferStates.add(s);
        for (Edge e : edges) {
            s = e.traverse(s);
            transferStates.add(s);
        }
        State[] states = transferStates.toArray(new State[0]);
        GraphPath<State, Edge, Vertex> graphPath = new GraphPath<State, Edge, Vertex>(states[states.length - 1]);
        Itinerary subItinerary = this.graphPathToItineraryMapper.generateItinerary(graphPath);
        if (subItinerary.getLegs().isEmpty()) {
            return List.of();
        }
        return subItinerary.getLegs();
    }

    private Itinerary mapDirectPath(RaptorPath<T> path) {
        return new Itinerary(List.of(new UnknownTransitPathLeg(this.mapPlace(this.request.from()), this.mapPlace(this.request.to()), this.createZonedDateTime(path.startTime()), this.createZonedDateTime(path.endTime()), path.numberOfTransfers())));
    }

    private Place mapPlace(GenericLocation location) {
        return Place.normal(location.lat, location.lng, new NonLocalizedString(location.label));
    }

    private ZonedDateTime createZonedDateTime(int timeInSeconds) {
        return this.transitSearchTimeZero.plusSeconds(timeInSeconds);
    }
}

