/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.groupids;

import java.util.Comparator;
import java.util.List;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupId;

public class GroupByDistance
implements GroupId<GroupByDistance> {
    private final List<Leg> keySet;
    private final boolean streetOnly;

    public GroupByDistance(Itinerary itinerary, double p) {
        this.assertPIsValid(p);
        double limit = p * GroupByDistance.calculateTotalDistance(itinerary.getLegs());
        this.streetOnly = itinerary.isStreetOnly();
        this.keySet = GroupByDistance.createKeySetOfLegsByLimit(itinerary.getLegs(), limit);
    }

    @Override
    public boolean match(GroupByDistance other) {
        if (this == other) {
            return true;
        }
        if (this.streetOnly != other.streetOnly) {
            return false;
        }
        return this.size() > other.size() ? this.contains(other) : other.contains(this);
    }

    @Override
    public GroupByDistance merge(GroupByDistance other) {
        return this.size() <= other.size() ? this : other;
    }

    public String toString() {
        return ToStringBuilder.of(GroupByDistance.class).addBoolIfTrue("streetOnly", this.streetOnly).addCol("keySet", this.keySet, GroupByDistance::keySetToString).toString();
    }

    int size() {
        return this.keySet.size();
    }

    static double calculateTotalDistance(List<Leg> legs) {
        return legs.stream().mapToDouble(Leg::getDistanceMeters).sum();
    }

    static List<Leg> createKeySetOfLegsByLimit(List<Leg> legs, double distanceLimitMeters) {
        legs = legs.stream().sorted(Comparator.comparingDouble(Leg::getDistanceMeters).reversed()).toList();
        double sum = 0.0;
        int i = 0;
        while (sum < distanceLimitMeters) {
            if (i == legs.size()) {
                throw new IllegalStateException("Did not expect to get here...");
            }
            sum += legs.get(i).getDistanceMeters();
            ++i;
        }
        return legs.stream().limit(i).toList();
    }

    List<Leg> getKeySet() {
        return List.copyOf(this.keySet);
    }

    private boolean contains(GroupByDistance other) {
        for (Leg leg : other.keySet) {
            if (!this.keySet.stream().noneMatch(leg::isPartiallySameLeg)) continue;
            return false;
        }
        return true;
    }

    private void assertPIsValid(double p) {
        if (p > 0.99 || p < 0.5) {
            throw new IllegalArgumentException("'p' is not between 0.01 and 0.99: " + p);
        }
    }

    private static String keySetToString(Leg leg) {
        ToStringBuilder builder = ToStringBuilder.of(leg.getClass()).addTime("start", leg.getStartTime()).addTime("end", leg.getStartTime());
        if (leg instanceof TransitLeg) {
            TransitLeg trLeg = (TransitLeg)leg;
            builder.addEnum("mode", trLeg.getMode()).addObj("tripId", leg.getTrip().getId());
        } else if (leg instanceof StreetLeg) {
            StreetLeg stLeg = (StreetLeg)leg;
            builder.addEnum("mode", stLeg.getMode());
        } else {
            throw new IllegalStateException("Unhandled type: " + leg.getClass());
        }
        return builder.toString();
    }
}

