/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain.comparator;

import java.util.Comparator;
import org.opentripplanner.framework.collection.CompositeComparator;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.SortOrder;

public class SortOrderComparator
extends CompositeComparator<Itinerary> {
    static final Comparator<Itinerary> STREET_ONLY_FIRST_COMP = (a, b) -> Boolean.compare(b.isOnStreetAllTheWay(), a.isOnStreetAllTheWay());
    static final Comparator<Itinerary> ARRIVAL_TIME_COMP = Comparator.comparing(Itinerary::endTime);
    static final Comparator<Itinerary> DEPARTURE_TIME_COMP = Comparator.comparing(Itinerary::startTime).reversed();
    static final Comparator<Itinerary> GENERALIZED_COST_COMP = Comparator.comparingInt(Itinerary::getGeneralizedCost);
    static final Comparator<Itinerary> NUM_OF_TRANSFERS_COMP = Comparator.comparingInt(Itinerary::getNumberOfTransfers);
    private static final SortOrderComparator STREET_AND_ARRIVAL_TIME = new SortOrderComparator(new Comparator[]{STREET_ONLY_FIRST_COMP, ARRIVAL_TIME_COMP, GENERALIZED_COST_COMP, NUM_OF_TRANSFERS_COMP, DEPARTURE_TIME_COMP});
    private static final SortOrderComparator STREET_AND_DEPARTURE_TIME = new SortOrderComparator(new Comparator[]{STREET_ONLY_FIRST_COMP, DEPARTURE_TIME_COMP, GENERALIZED_COST_COMP, NUM_OF_TRANSFERS_COMP, ARRIVAL_TIME_COMP});
    private static final SortOrderComparator GENERALIZED_COST = new SortOrderComparator(new Comparator[]{GENERALIZED_COST_COMP, NUM_OF_TRANSFERS_COMP});
    private static final SortOrderComparator NUM_TRANSFERS = new SortOrderComparator(new Comparator[]{NUM_OF_TRANSFERS_COMP, GENERALIZED_COST_COMP});

    @SafeVarargs
    private SortOrderComparator(Comparator<Itinerary> ... compareVector) {
        super(compareVector);
    }

    public static SortOrderComparator defaultComparatorDepartAfter() {
        return STREET_AND_ARRIVAL_TIME;
    }

    public static SortOrderComparator defaultComparatorArriveBy() {
        return STREET_AND_DEPARTURE_TIME;
    }

    public static SortOrderComparator generalizedCostComparator() {
        return GENERALIZED_COST;
    }

    public static SortOrderComparator numberOfTransfersComparator() {
        return NUM_TRANSFERS;
    }

    public static SortOrderComparator comparator(SortOrder sortOrder) {
        switch (sortOrder) {
            case STREET_AND_ARRIVAL_TIME: {
                return STREET_AND_ARRIVAL_TIME;
            }
            case STREET_AND_DEPARTURE_TIME: {
                return STREET_AND_DEPARTURE_TIME;
            }
        }
        throw new IllegalArgumentException();
    }
}

