/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.filterchain;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.opentripplanner.ext.accessibilityscore.AccessibilityScoreFilter;
import org.opentripplanner.ext.fares.FaresFilter;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.routing.algorithm.filterchain.GroupBySimilarity;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilterChain;
import org.opentripplanner.routing.algorithm.filterchain.ListSection;
import org.opentripplanner.routing.algorithm.filterchain.api.TransitGeneralizedCostFilterParams;
import org.opentripplanner.routing.algorithm.filterchain.comparator.SortOrderComparator;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.LatestDepartureTimeFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.MaxLimitFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.NonTransitGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.OtherThanSameLegsMaxGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveBikerentalWithMostlyWalkingFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveItinerariesWithShortStreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveParkAndRideWithMostlyWalkingFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveTransitIfStreetOnlyIsBetterFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.RemoveWalkOnlyFilter;
import org.opentripplanner.routing.algorithm.filterchain.deletionflagger.TransitGeneralizedCostFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.DeletionFlaggingFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.GroupByFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.RemoveDeletionFlagForLeastTransfersItinerary;
import org.opentripplanner.routing.algorithm.filterchain.filter.SameFirstOrLastTripFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.SortingFilter;
import org.opentripplanner.routing.algorithm.filterchain.filter.TransitAlertFilter;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupByAllSameStations;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupByDistance;
import org.opentripplanner.routing.algorithm.filterchain.groupids.GroupBySameRoutesAndStops;
import org.opentripplanner.routing.api.request.framework.DoubleAlgorithmFunction;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Station;

public class ItineraryListFilterChainBuilder {
    private static final int NOT_SET = -1;
    private final SortOrder sortOrder;
    private final List<GroupBySimilarity> groupBySimilarity = new ArrayList<GroupBySimilarity>();
    private boolean debug = false;
    private int maxNumberOfItineraries = -1;
    private ListSection maxNumberOfItinerariesCrop = ListSection.TAIL;
    private boolean removeTransitWithHigherCostThanBestOnStreetOnly = true;
    private boolean removeWalkAllTheWayResults;
    private boolean sameFirstOrLastTripFilter;
    private TransitGeneralizedCostFilterParams transitGeneralizedCostFilterParams;
    private double bikeRentalDistanceRatio;
    private double parkAndRideDurationRatio;
    private DoubleAlgorithmFunction nonTransitGeneralizedCostLimit;
    private Instant latestDepartureTimeLimit = null;
    private Consumer<Itinerary> maxLimitReachedSubscriber;
    private boolean accessibilityScore;
    private double wheelchairMaxSlope;
    private FareService faresService;
    private TransitAlertService transitAlertService;
    private Function<Station, MultiModalStation> getMultiModalStation;
    private boolean removeItinerariesWithSameRoutesAndStops;
    private double minBikeParkingDistance;
    private ItineraryListFilter rideHailingFilter;

    public ItineraryListFilterChainBuilder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ItineraryListFilterChainBuilder withMaxNumberOfItineraries(int value) {
        this.maxNumberOfItineraries = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withMaxNumberOfItinerariesCrop(ListSection section) {
        this.maxNumberOfItinerariesCrop = section;
        return this;
    }

    public ItineraryListFilterChainBuilder addGroupBySimilarity(GroupBySimilarity groupBySimilarity) {
        this.groupBySimilarity.add(groupBySimilarity);
        return this;
    }

    public ItineraryListFilterChainBuilder withTransitGeneralizedCostLimit(TransitGeneralizedCostFilterParams transitGeneralizedCostFilterParams) {
        this.transitGeneralizedCostFilterParams = transitGeneralizedCostFilterParams;
        return this;
    }

    public ItineraryListFilterChainBuilder withNonTransitGeneralizedCostLimit(DoubleAlgorithmFunction value) {
        this.nonTransitGeneralizedCostLimit = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withBikeRentalDistanceRatio(double value) {
        this.bikeRentalDistanceRatio = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withParkAndRideDurationRatio(double value) {
        this.parkAndRideDurationRatio = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveTransitWithHigherCostThanBestOnStreetOnly(boolean value) {
        this.removeTransitWithHigherCostThanBestOnStreetOnly = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withDebugEnabled(boolean value) {
        this.debug = value;
        return this;
    }

    public ItineraryListFilterChainBuilder withLatestDepartureTimeLimit(Instant latestDepartureTimeLimit) {
        this.latestDepartureTimeLimit = latestDepartureTimeLimit;
        return this;
    }

    public ItineraryListFilterChainBuilder withMaxLimitReachedSubscriber(Consumer<Itinerary> maxLimitReachedSubscriber) {
        this.maxLimitReachedSubscriber = maxLimitReachedSubscriber;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveWalkAllTheWayResults(boolean enable) {
        this.removeWalkAllTheWayResults = enable;
        return this;
    }

    public ItineraryListFilterChainBuilder withSameFirstOrLastTripFilter(boolean enable) {
        this.sameFirstOrLastTripFilter = enable;
        return this;
    }

    public ItineraryListFilterChainBuilder withAccessibilityScore(boolean enable, double wheelchairMaxSlope) {
        this.accessibilityScore = enable;
        this.wheelchairMaxSlope = wheelchairMaxSlope;
        return this;
    }

    public ItineraryListFilterChainBuilder withFares(FareService fareService) {
        this.faresService = fareService;
        return this;
    }

    public ItineraryListFilterChainBuilder withMinBikeParkingDistance(double distance) {
        this.minBikeParkingDistance = distance;
        return this;
    }

    public ItineraryListFilterChainBuilder withRemoveTimeshiftedItinerariesWithSameRoutesAndStops(boolean remove) {
        this.removeItinerariesWithSameRoutesAndStops = remove;
        return this;
    }

    public ItineraryListFilterChainBuilder withRideHailingFilter(ItineraryListFilter filter) {
        this.rideHailingFilter = filter;
        return this;
    }

    public ItineraryListFilterChain build() {
        ArrayList<ItineraryListFilter> filters = new ArrayList<ItineraryListFilter>();
        filters.addAll(this.buildGroupByTripIdAndDistanceFilters());
        if (this.removeItinerariesWithSameRoutesAndStops) {
            filters.addAll(this.buildGroupBySameRoutesAndStopsFilter());
        }
        if (this.sameFirstOrLastTripFilter) {
            filters.add(new SortingFilter(SortOrderComparator.generalizedCostComparator()));
            filters.add(new DeletionFlaggingFilter(new SameFirstOrLastTripFilter()));
        }
        if (this.minBikeParkingDistance > 0.0) {
            filters.add(new RemoveItinerariesWithShortStreetLeg(this.minBikeParkingDistance, TraverseMode.BICYCLE));
        }
        if (this.accessibilityScore) {
            filters.add(new AccessibilityScoreFilter(this.wheelchairMaxSlope));
        }
        if (this.faresService != null) {
            filters.add(new FaresFilter(this.faresService));
        }
        if (this.transitAlertService != null) {
            filters.add(new TransitAlertFilter(this.transitAlertService, this.getMultiModalStation));
        }
        if (this.transitGeneralizedCostFilterParams != null) {
            filters.add(new DeletionFlaggingFilter(new TransitGeneralizedCostFilter(this.transitGeneralizedCostFilterParams)));
        }
        if (this.nonTransitGeneralizedCostLimit != null) {
            filters.add(new DeletionFlaggingFilter(new NonTransitGeneralizedCostFilter(this.nonTransitGeneralizedCostLimit)));
        }
        if (this.removeTransitWithHigherCostThanBestOnStreetOnly) {
            filters.add(new DeletionFlaggingFilter(new RemoveTransitIfStreetOnlyIsBetterFilter()));
        }
        if (this.removeWalkAllTheWayResults) {
            filters.add(new DeletionFlaggingFilter(new RemoveWalkOnlyFilter()));
        }
        if (this.latestDepartureTimeLimit != null) {
            filters.add(new DeletionFlaggingFilter(new LatestDepartureTimeFilter(this.latestDepartureTimeLimit)));
        }
        if (this.bikeRentalDistanceRatio > 0.0) {
            filters.add(new DeletionFlaggingFilter(new RemoveBikerentalWithMostlyWalkingFilter(this.bikeRentalDistanceRatio)));
        }
        if (this.parkAndRideDurationRatio > 0.0) {
            filters.add(new DeletionFlaggingFilter(new RemoveParkAndRideWithMostlyWalkingFilter(this.parkAndRideDurationRatio)));
        }
        if (this.maxNumberOfItineraries > 0) {
            filters.add(new SortingFilter(SortOrderComparator.comparator(this.sortOrder)));
            filters.add(new DeletionFlaggingFilter(new MaxLimitFilter("number-of-itineraries-filter", this.maxNumberOfItineraries, this.maxNumberOfItinerariesCrop, this.maxLimitReachedSubscriber)));
        }
        filters.add(new SortingFilter(SortOrderComparator.comparator(this.sortOrder)));
        if (this.rideHailingFilter != null) {
            filters.add(this.rideHailingFilter);
        }
        return new ItineraryListFilterChain(filters, this.debug);
    }

    public ItineraryListFilterChainBuilder withTransitAlerts(TransitAlertService transitAlertService, Function<Station, MultiModalStation> getMultiModalStation) {
        this.transitAlertService = transitAlertService;
        this.getMultiModalStation = getMultiModalStation;
        return this;
    }

    private List<ItineraryListFilter> buildGroupBySameRoutesAndStopsFilter() {
        return List.of(new GroupByFilter<GroupBySameRoutesAndStops>(GroupBySameRoutesAndStops::new, List.of(new SortingFilter(SortOrderComparator.comparator(this.sortOrder)), new DeletionFlaggingFilter(new MaxLimitFilter("group-by-same-stations-and-routes", 1)))));
    }

    private List<ItineraryListFilter> buildGroupByTripIdAndDistanceFilters() {
        List<GroupBySimilarity> groupBy = this.groupBySimilarity.stream().sorted(Comparator.comparingDouble(o -> o.groupByP)).toList();
        ArrayList<ItineraryListFilter> groupByFilters = new ArrayList<ItineraryListFilter>();
        for (GroupBySimilarity group : groupBy) {
            String name = "similar-legs-filter-%.0fp-%dx".formatted(100.0 * group.groupByP, group.maxNumOfItinerariesPerGroup);
            ArrayList<ItineraryListFilter> nested = new ArrayList<ItineraryListFilter>();
            if (group.nestedGroupingByAllSameStations) {
                String innerGroupName = name + "-group-by-all-same-stations";
                nested.add(new GroupByFilter<GroupByAllSameStations>(GroupByAllSameStations::new, List.of(new SortingFilter(SortOrderComparator.generalizedCostComparator()), new DeletionFlaggingFilter(new MaxLimitFilter(innerGroupName, 1)))));
            }
            if (group.maxCostOtherLegsFactor > 1.0) {
                nested.add(new DeletionFlaggingFilter(new OtherThanSameLegsMaxGeneralizedCostFilter(group.maxCostOtherLegsFactor)));
            }
            nested.add(new SortingFilter(SortOrderComparator.generalizedCostComparator()));
            nested.add(new DeletionFlaggingFilter(new MaxLimitFilter(name, group.maxNumOfItinerariesPerGroup)));
            nested.add(new RemoveDeletionFlagForLeastTransfersItinerary());
            groupByFilters.add(new GroupByFilter<GroupByDistance>(it -> new GroupByDistance((Itinerary)it, group.groupByP), nested));
        }
        return groupByFilters;
    }
}

