/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.util;

import org.opentripplanner.raptor.spi.IntIterator;

public class IntIterators {
    private IntIterators() {
    }

    public static IntIterator intIncIterator(final int startValue, final int endValue) {
        return new IntIterator(){
            private int i;
            {
                this.i = startValue;
            }

            @Override
            public int next() {
                return this.i++;
            }

            @Override
            public boolean hasNext() {
                return this.i < endValue;
            }
        };
    }

    public static IntIterator intIncIterator(final int startValue, final int endValue, final int increment) {
        return new IntIterator(){
            private int i;
            {
                this.i = startValue;
            }

            @Override
            public int next() {
                return this.i += increment;
            }

            @Override
            public boolean hasNext() {
                return this.i < endValue;
            }
        };
    }

    public static IntIterator intDecIterator(final int startValue, final int endValue) {
        return new IntIterator(){
            private int i;
            {
                this.i = startValue - 1;
            }

            @Override
            public int next() {
                return this.i--;
            }

            @Override
            public boolean hasNext() {
                return this.i >= endValue;
            }
        };
    }

    public static IntIterator intDecIterator(final int startValue, final int endValue, final int decrement) {
        return new IntIterator(){
            private int i;
            {
                this.i = startValue - decrement;
            }

            @Override
            public int next() {
                int tmp = this.i;
                this.i -= decrement;
                return tmp;
            }

            @Override
            public boolean hasNext() {
                return this.i >= endValue;
            }
        };
    }

    public static IntIterator singleValueIterator(int value) {
        return IntIterators.intIncIterator(value, value + 1);
    }
}

