/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.spi;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.spi.EmptyBoardOrAlightEvent;

public interface RaptorBoardOrAlightEvent<T extends RaptorTripSchedule> {
    public int tripIndex();

    public T trip();

    public int stopPositionInPattern();

    default public int boardStopIndex() {
        return this.trip().pattern().stopIndex(this.stopPositionInPattern());
    }

    public int time();

    public int earliestBoardTime();

    @Nonnull
    public RaptorTransferConstraint transferConstraint();

    public boolean empty();

    default public void boardWithFallback(Consumer<RaptorBoardOrAlightEvent<T>> boardCallback, Consumer<RaptorBoardOrAlightEvent<T>> alternativeBoardingFallback) {
        if (this.empty()) {
            alternativeBoardingFallback.accept(this);
        } else {
            boardCallback.accept(this);
        }
    }

    public static <S extends RaptorTripSchedule> RaptorBoardOrAlightEvent<S> empty(int earliestBoardTime) {
        return new EmptyBoardOrAlightEvent(earliestBoardTime);
    }
}

