/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.service;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.SearchParams;
import org.opentripplanner.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.raptor.api.response.RaptorResponse;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorker;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorSearchWindowCalculator;
import org.opentripplanner.raptor.service.DefaultStopArrivals;
import org.opentripplanner.raptor.service.DestinationNotReachedException;
import org.opentripplanner.raptor.service.HeuristicSearchTask;
import org.opentripplanner.raptor.service.HeuristicToRunResolver;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeRaptorDynamicSearch<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(RangeRaptorDynamicSearch.class);
    private final RaptorConfig<T> config;
    private final RaptorTransitDataProvider<T> transitData;
    private final RaptorRequest<T> originalRequest;
    private final RaptorSearchWindowCalculator dynamicSearchParamsCalculator;
    private final HeuristicSearchTask<T> fwdHeuristics;
    private final HeuristicSearchTask<T> revHeuristics;

    public RangeRaptorDynamicSearch(RaptorConfig<T> config, RaptorTransitDataProvider<T> transitData, RaptorRequest<T> originalRequest) {
        this.config = config;
        this.transitData = transitData;
        this.originalRequest = originalRequest;
        this.dynamicSearchParamsCalculator = config.searchWindowCalculator().withSearchParams(originalRequest.searchParams());
        this.fwdHeuristics = new HeuristicSearchTask<T>(SearchDirection.FORWARD, "Forward", config, transitData);
        this.revHeuristics = new HeuristicSearchTask<T>(SearchDirection.REVERSE, "Reverse", config, transitData);
    }

    public RaptorResponse<T> route() {
        try {
            this.enableHeuristicSearchBasedOnOptimizationsAndSearchParameters();
            this.runHeuristics();
            RaptorRequest<T> dynamicRequest = this.originalRequest;
            dynamicRequest = this.requestWithDynamicSearchParams(dynamicRequest);
            return this.createAndRunDynamicRRWorker(dynamicRequest);
        }
        catch (DestinationNotReachedException e) {
            return new RaptorResponse(Collections.emptyList(), null, this.originalRequest, this.requestWithDynamicSearchParams(this.originalRequest));
        }
    }

    @Nullable
    public Heuristics getDestinationHeuristics() {
        if (!this.originalRequest.useDestinationPruning()) {
            return null;
        }
        LOG.debug("RangeRaptor - Destination pruning enabled.");
        return this.revHeuristics.result();
    }

    private void enableHeuristicSearchBasedOnOptimizationsAndSearchParameters() {
        HeuristicToRunResolver.resolveHeuristicToRunBasedOnOptimizationsAndSearchParameters(this.originalRequest, this.fwdHeuristics::enable, this.revHeuristics::enable);
    }

    private void runHeuristics() {
        if (this.isItPossibleToRunHeuristicsInParallel()) {
            this.runHeuristicsInParallel();
        } else {
            this.runHeuristicsSequentially();
        }
        this.fwdHeuristics.debugCompareResult(this.revHeuristics);
    }

    private RaptorResponse<T> createAndRunDynamicRRWorker(RaptorRequest<T> request) {
        LOG.debug("Main request: {}", request);
        RaptorWorker<T> raptorWorker = request.profile().is(RaptorProfile.MULTI_CRITERIA) ? this.config.createMcWorker(this.transitData, request, this.getDestinationHeuristics()) : this.config.createStdWorker(this.transitData, request);
        RaptorWorkerResult<T> result = raptorWorker.route();
        return new RaptorResponse<T>(result.extractPaths(), new DefaultStopArrivals(result), this.originalRequest, request);
    }

    private boolean isItPossibleToRunHeuristicsInParallel() {
        SearchParams s = this.originalRequest.searchParams();
        return this.config.isMultiThreaded() && this.originalRequest.runInParallel() && s.isEarliestDepartureTimeSet() && s.isLatestArrivalTimeSet() && this.fwdHeuristics.isEnabled() && this.revHeuristics.isEnabled();
    }

    private void runHeuristicsInParallel() {
        try {
            this.fwdHeuristics.withRequest(this.originalRequest);
            this.revHeuristics.withRequest(this.originalRequest);
            Future<?> f = this.config.threadPool().submit(this.fwdHeuristics::run);
            this.revHeuristics.run();
            f.get();
            LOG.debug("Route using RangeRaptor - REVERSE and FORWARD heuristic search performed in parallel.");
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof DestinationNotReachedException) {
                throw new DestinationNotReachedException();
            }
            LOG.error(e.getMessage() + ". Request: " + this.originalRequest, (Throwable)e);
            throw new IllegalStateException("Failed to run FORWARD/REVERSE heuristic search in parallel. Details: " + e.getMessage());
        }
    }

    private void runHeuristicsSequentially() {
        List<HeuristicSearchTask<T>> tasks = this.listTasksInOrder();
        if (tasks.isEmpty()) {
            return;
        }
        Heuristics result = this.runHeuristicSearchTask(tasks.get(0));
        this.calculateDynamicSearchParametersFromHeuristics(result);
        if (tasks.size() == 1) {
            return;
        }
        this.runHeuristicSearchTask(tasks.get(1));
    }

    private Heuristics runHeuristicSearchTask(HeuristicSearchTask<T> task) {
        RaptorRequest<T> request = task.getDirection().isForward() ? this.requestForForwardHeurSearchWithDynamicSearchParams() : this.requestForReverseHeurSearchWithDynamicSearchParams();
        task.withRequest(request).run();
        return task.result();
    }

    private List<HeuristicSearchTask<T>> listTasksInOrder() {
        boolean performForwardFirst = this.originalRequest.searchParams().isEarliestDepartureTimeSet();
        List<HeuristicSearchTask<T>> list = performForwardFirst ? List.of(this.fwdHeuristics, this.revHeuristics) : List.of(this.revHeuristics, this.fwdHeuristics);
        return list.stream().filter(HeuristicSearchTask::isEnabled).collect(Collectors.toList());
    }

    private RaptorRequest<T> requestForForwardHeurSearchWithDynamicSearchParams() {
        if (this.originalRequest.searchParams().isEarliestDepartureTimeSet()) {
            return this.originalRequest;
        }
        return this.originalRequest.mutate().searchParams().earliestDepartureTime(this.transitData.getValidTransitDataStartTime()).build();
    }

    private RaptorRequest<T> requestForReverseHeurSearchWithDynamicSearchParams() {
        if (this.originalRequest.searchParams().isLatestArrivalTimeSet()) {
            return this.originalRequest;
        }
        return this.originalRequest.mutate().searchParams().latestArrivalTime(this.transitData.getValidTransitDataEndTime() + this.originalRequest.searchParams().accessEgressMaxDurationSeconds()).build();
    }

    private RaptorRequest<T> requestWithDynamicSearchParams(RaptorRequest<T> request) {
        SearchParamsBuilder<T> builder = request.mutate().searchParams();
        if (!request.searchParams().isEarliestDepartureTimeSet()) {
            builder.earliestDepartureTime(this.dynamicSearchParamsCalculator.getEarliestDepartureTime());
        }
        if (!request.searchParams().isSearchWindowSet()) {
            builder.searchWindowInSeconds(this.dynamicSearchParamsCalculator.getSearchWindowSeconds());
        }
        return builder.build();
    }

    private void calculateDynamicSearchParametersFromHeuristics(@Nullable Heuristics heuristics) {
        if (heuristics != null) {
            this.dynamicSearchParamsCalculator.withHeuristics(heuristics.bestOverallJourneyTravelDuration(), heuristics.minWaitTimeForJourneysReachingDestination()).calculate();
        }
    }
}

