/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.service;

import javax.annotation.Nullable;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorker;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.service.DebugHeuristics;
import org.opentripplanner.raptor.service.DestinationNotReachedException;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeuristicSearchTask<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(HeuristicSearchTask.class);
    private final SearchDirection direction;
    private final String name;
    private final RaptorConfig<T> config;
    private final RaptorTransitDataProvider<T> transitData;
    private boolean run = false;
    private RaptorWorker<T> search = null;
    private RaptorRequest<T> originalRequest;
    private RaptorRequest<T> heuristicRequest;
    private RaptorWorkerResult<T> result = null;

    public HeuristicSearchTask(RaptorRequest<T> request, RaptorConfig<T> config, RaptorTransitDataProvider<T> transitData) {
        this(request.searchDirection(), request.alias(), config, transitData);
        this.originalRequest = request;
    }

    public HeuristicSearchTask(SearchDirection direction, String name, RaptorConfig<T> config, RaptorTransitDataProvider<T> transitData) {
        this.direction = direction;
        this.name = name;
        this.config = config;
        this.transitData = transitData;
    }

    public String name() {
        return this.name;
    }

    public void enable() {
        this.run = true;
    }

    public boolean isEnabled() {
        return this.run;
    }

    public SearchDirection getDirection() {
        return this.direction;
    }

    @Nullable
    public Heuristics result() {
        if (this.result == null) {
            return null;
        }
        return this.config.createHeuristic(this.transitData, this.heuristicRequest, this.result);
    }

    public HeuristicSearchTask<T> withRequest(RaptorRequest<T> request) {
        this.originalRequest = request;
        return this;
    }

    public void forceRun() {
        this.enable();
        this.run();
    }

    public void debugCompareResult(HeuristicSearchTask<T> other) {
        if (!this.isEnabled() || !other.isEnabled()) {
            return;
        }
        DebugHeuristics.debug(this.name(), this.result(), other.name(), other.result(), this.originalRequest);
    }

    void run() {
        if (!this.run) {
            return;
        }
        long start = System.currentTimeMillis();
        this.createHeuristicSearchIfNotExist(this.originalRequest);
        LOG.debug("Heuristic search: {}", this.heuristicRequest);
        this.result = this.search.route();
        LOG.debug("Heuristic result: {}", this.result);
        if (!this.result.isDestinationReached()) {
            throw new DestinationNotReachedException();
        }
        if (LOG.isDebugEnabled()) {
            String time = DurationUtils.msToSecondsStr(System.currentTimeMillis() - start);
            LOG.debug("RangeRaptor - {} heuristic search performed in {}.", (Object)this.name, (Object)time);
        }
    }

    private void createHeuristicSearchIfNotExist(RaptorRequest<T> request) {
        if (this.search == null) {
            RaptorProfile profile = RaptorProfile.MIN_TRAVEL_DURATION;
            RaptorRequestBuilder<T> builder = request.mutate().clearOptimizations().profile(profile).searchDirection(this.direction);
            builder.searchParams().searchOneIterationOnly();
            builder.performanceTimers(request.performanceTimers().withNamePrefix(builder.generateAlias()));
            this.heuristicRequest = builder.build();
            this.search = this.config.createHeuristicSearch(this.transitData, this.heuristicRequest);
        }
    }
}

