/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.service;

import java.util.Comparator;
import org.opentripplanner.framework.lang.IntUtils;
import org.opentripplanner.raptor.api.debug.DebugLogger;
import org.opentripplanner.raptor.api.debug.DebugTopic;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.DebugRequest;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.util.CompareIntArrays;

public class DebugHeuristics {
    private final String aName;
    private final String bName;
    private final DebugLogger logger;
    private final int[] stops;

    private DebugHeuristics(String aName, String bName, DebugRequest debugRequest) {
        this.aName = aName;
        this.bName = bName;
        this.logger = debugRequest.logger();
        this.stops = IntUtils.concat(debugRequest.stops(), debugRequest.path());
    }

    public static void debug(String aName, Heuristics h1, String bName, Heuristics h2, RaptorRequest<?> request) {
        DebugRequest debug = request.debug();
        if (debug.logger().isEnabled()) {
            new DebugHeuristics(aName, bName, debug).debug(h1, h2, request.searchDirection());
        }
    }

    private void log(String message) {
        this.logger.debug(DebugTopic.HEURISTICS, message);
    }

    private void debug(Heuristics fwdHeur, Heuristics revHeur, SearchDirection direction) {
        this.log(CompareIntArrays.compare("NUMBER OF TRANSFERS", this.aName, fwdHeur.bestNumOfTransfersToIntArray(2000000000), this.bName, revHeur.bestNumOfTransfersToIntArray(2000000000), 2000000000, this.stops, Comparator.comparingInt(i -> i)));
        this.log(CompareIntArrays.compareTime("TRAVEL DURATION", this.aName, fwdHeur.bestTravelDurationToIntArray(2000000000), this.bName, revHeur.bestTravelDurationToIntArray(2000000000), 2000000000, this.stops, direction.isForward() ? Comparator.comparingInt(i -> i) : (l, r) -> r - l));
        this.log(CompareIntArrays.compareTime("GENERALIZED COST", this.aName, fwdHeur.bestGeneralizedCostToIntArray(2000000000), this.bName, revHeur.bestGeneralizedCostToIntArray(2000000000), 2000000000, this.stops, direction.isForward() ? Comparator.comparingInt(i -> i) : (l, r) -> r - l));
    }
}

