/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;

public final class TripScheduleExactMatchSearch<T extends RaptorTripSchedule>
implements RaptorTripScheduleSearch<T> {
    private final int slack;
    private final RaptorTripScheduleSearch<T> delegate;
    private final TransitCalculator<T> calculator;

    TripScheduleExactMatchSearch(RaptorTripScheduleSearch<T> delegate, TransitCalculator<T> calculator, int slack) {
        this.delegate = delegate;
        this.slack = slack;
        this.calculator = calculator;
    }

    @Override
    public RaptorBoardOrAlightEvent<T> search(int timeLimit, int stopPositionInPattern, int tripIndexLimit) {
        RaptorBoardOrAlightEvent<T> result = this.delegate.search(timeLimit, stopPositionInPattern, tripIndexLimit);
        if (result.empty() || result.transferConstraint().isNotAllowed()) {
            return result;
        }
        return this.isWithinSlack(timeLimit, result.time()) ? result : RaptorBoardOrAlightEvent.empty(result.earliestBoardTime());
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleExactMatchSearch.class).addNum("slack", this.slack).addObj("delegate", this.delegate).toString();
    }

    private boolean isWithinSlack(int timeLimit, int time) {
        return this.calculator.isBefore(time, timeLimit + this.slack);
    }
}

