/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import org.opentripplanner.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;

public class RoundTracker
implements RoundProvider {
    private final int numberOfAdditionalTransfers;
    private int round = 0;
    private int roundMaxLimit;

    public RoundTracker(int nRounds, int numberOfAdditionalTransfers, WorkerLifeCycle lifeCycle) {
        this.roundMaxLimit = nRounds;
        this.numberOfAdditionalTransfers = numberOfAdditionalTransfers;
        lifeCycle.onSetupIteration(t -> this.setupIteration());
        lifeCycle.onRoundComplete(this::roundComplete);
    }

    public boolean hasMoreRounds() {
        return this.round + 1 < this.roundMaxLimit;
    }

    public int nextRound() {
        return ++this.round;
    }

    @Override
    public int round() {
        return this.round;
    }

    @Override
    public boolean isFirstRound() {
        return this.round == 1;
    }

    private void setupIteration() {
        this.round = 0;
    }

    private void roundComplete(boolean destinationReached) {
        if (destinationReached) {
            this.recalculateMaxLimitBasedOnDestinationReachedInCurrentRound();
        }
    }

    private void recalculateMaxLimitBasedOnDestinationReachedInCurrentRound() {
        this.roundMaxLimit = Math.min(this.roundMaxLimit, this.round + this.numberOfAdditionalTransfers + 1);
    }
}

