/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import java.util.Iterator;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.api.request.SearchParams;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.ReverseTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.TripScheduleExactMatchSearch;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorTimeTable;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.raptor.spi.RaptorTripScheduleSearch;
import org.opentripplanner.raptor.util.IntIterators;

public final class ReverseRaptorTransitCalculator<T extends RaptorTripSchedule>
extends ReverseTransitCalculator<T>
implements RaptorTransitCalculator<T> {
    private final int latestArrivalTime;
    private final int searchWindowInSeconds;
    private final int earliestAcceptableDepartureTime;
    private final int iterationStep;

    public ReverseRaptorTransitCalculator(SearchParams s, RaptorTuningParameters t) {
        this(s.latestArrivalTime(), s.searchWindowInSeconds(), s.earliestDepartureTime(), t.iterationDepartureStepInSeconds());
    }

    ReverseRaptorTransitCalculator(int latestArrivalTime, int searchWindowInSeconds, int earliestAcceptableDepartureTime, int iterationStep) {
        this.latestArrivalTime = latestArrivalTime;
        this.searchWindowInSeconds = searchWindowInSeconds;
        this.earliestAcceptableDepartureTime = earliestAcceptableDepartureTime == -1999000000 ? this.unreachedTime() : earliestAcceptableDepartureTime;
        this.iterationStep = iterationStep;
    }

    @Override
    public boolean exceedsTimeLimit(int time) {
        return this.isBefore(this.earliestAcceptableDepartureTime, time);
    }

    @Override
    public String exceedsTimeLimitReason() {
        return "The departure time exceeds the time limit, depart to early: " + TimeUtils.timeToStrLong(this.earliestAcceptableDepartureTime) + ".";
    }

    @Override
    public IntIterator rangeRaptorMinutes() {
        return this.oneIterationOnly() ? IntIterators.singleValueIterator(this.latestArrivalTime) : IntIterators.intIncIterator(this.latestArrivalTime - this.searchWindowInSeconds, this.latestArrivalTime, this.iterationStep);
    }

    @Override
    public int minIterationDepartureTime() {
        return this.latestArrivalTime;
    }

    @Override
    public boolean oneIterationOnly() {
        return this.searchWindowInSeconds <= this.iterationStep;
    }

    @Override
    public IntIterator patternStopIterator(int nStopsInPattern) {
        return IntIterators.intDecIterator(nStopsInPattern, 0);
    }

    @Override
    public RaptorConstrainedBoardingSearch<T> transferConstraintsSearch(RaptorTransitDataProvider<T> transitData, int routeIndex) {
        return transitData.transferConstraintsReverseSearch(routeIndex);
    }

    @Override
    public Iterator<? extends RaptorTransfer> getTransfers(RaptorTransitDataProvider<T> transitDataProvider, int fromStop) {
        return transitDataProvider.getTransfersToStop(fromStop);
    }

    @Override
    public RaptorTripScheduleSearch<T> createTripSearch(RaptorTimeTable<T> timeTable) {
        return timeTable.tripSearch(SearchDirection.REVERSE);
    }

    @Override
    public RaptorTripScheduleSearch<T> createExactTripSearch(RaptorTimeTable<T> timeTable) {
        return new TripScheduleExactMatchSearch<T>(this.createTripSearch(timeTable), this, -this.iterationStep);
    }
}

