/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.transit;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;
import org.opentripplanner.raptor.util.paretoset.ParetoSet;

public final class AccessEgressFunctions {
    private static final ParetoComparator<RaptorAccessEgress> STANDARD_COMPARATOR = (l, r) -> l.stopReachedOnBoard() && !r.stopReachedOnBoard() || r.hasOpeningHours() || l.numberOfRides() < r.numberOfRides() || l.durationInSeconds() < r.durationInSeconds();

    private AccessEgressFunctions() {
    }

    static Collection<RaptorAccessEgress> removeNoneOptimalPathsForStandardRaptor(Collection<RaptorAccessEgress> paths) {
        TIntObjectMap<List<RaptorAccessEgress>> mapByStop = AccessEgressFunctions.groupByStop(paths);
        ParetoSet<RaptorAccessEgress> set = new ParetoSet<RaptorAccessEgress>(STANDARD_COMPARATOR);
        ArrayList<RaptorAccessEgress> result = new ArrayList<RaptorAccessEgress>();
        mapByStop.forEachValue(list -> {
            set.clear();
            set.addAll(list);
            result.addAll(set);
            return true;
        });
        return result;
    }

    static TIntObjectMap<List<RaptorAccessEgress>> groupByRound(Collection<RaptorAccessEgress> input, Predicate<RaptorAccessEgress> include) {
        return AccessEgressFunctions.groupBy(input.stream().filter(include).collect(Collectors.toList()), RaptorAccessEgress::numberOfRides);
    }

    static TIntObjectMap<List<RaptorAccessEgress>> groupByStop(Collection<RaptorAccessEgress> input) {
        return AccessEgressFunctions.groupBy(input, RaptorAccessEgress::stop);
    }

    private static List<RaptorAccessEgress> getOrCreate(int key, TIntObjectMap<List<RaptorAccessEgress>> map) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        return (List)map.get(key);
    }

    private static TIntObjectMap<List<RaptorAccessEgress>> groupBy(Collection<RaptorAccessEgress> input, ToIntFunction<RaptorAccessEgress> groupBy) {
        TIntObjectHashMap mapByRound = new TIntObjectHashMap();
        for (RaptorAccessEgress it : input) {
            AccessEgressFunctions.getOrCreate(groupBy.applyAsInt(it), (TIntObjectMap<List<RaptorAccessEgress>>)mapByRound).add(it);
        }
        return mapByRound;
    }
}

