/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view;

import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.StdStopArrivals;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.StopArrivalState;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.Access;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.Transfer;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.Transit;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;

public class StopsCursor<T extends RaptorTripSchedule> {
    private final StdStopArrivals<T> arrivals;
    private final TransitCalculator<T> transitCalculator;
    private final ToIntFunction<RaptorTripPattern> boardSlackProvider;

    public StopsCursor(StdStopArrivals<T> arrivals, TransitCalculator<T> transitCalculator, ToIntFunction<RaptorTripPattern> boardSlackProvider) {
        this.arrivals = arrivals;
        this.transitCalculator = transitCalculator;
        this.boardSlackProvider = boardSlackProvider;
    }

    public boolean reachedOnBoard(int round, int stop) {
        StopArrivalState<T> a = this.arrivals.get(round, stop);
        return a != null && a.reachedOnBoard();
    }

    public boolean reachedOnStreet(int round, int stop) {
        StopArrivalState<T> a = this.arrivals.get(round, stop);
        if (a == null) {
            return false;
        }
        return a.arrivedByAccessOnStreet() || a.arrivedByTransfer();
    }

    public Access<T> fictiveAccess(int round, RaptorAccessEgress accessPath, int arrivalTime) {
        return new Access(round, arrivalTime, accessPath);
    }

    public Transfer<T> fictiveTransfer(int round, int fromStop, RaptorTransfer transfer, int toStop, int arrivalTime) {
        StopArrivalState arrival = StopArrivalState.create();
        arrival.transferToStop(fromStop, arrivalTime, transfer);
        return new Transfer(round, toStop, arrival, this);
    }

    public Transit<T> fictiveTransit(int round, int alightStop, int alightTime, T trip, int boardStop, int boardTime) {
        StopArrivalState<T> arrival = StopArrivalState.create();
        arrival.arriveByTransit(alightTime, boardStop, boardTime, trip);
        return new Transit(round, alightStop, arrival, this);
    }

    public ArrivalView<T> access(int round, int stop, RaptorAccessEgress access) {
        StopArrivalState<T> arrival = this.arrivals.get(round, stop);
        int time = access.stopReachedOnBoard() ? arrival.onBoardArrivalTime() : arrival.time();
        return new Access(round, time, access);
    }

    public ArrivalView<T> stop(int round, int stop, boolean stopReachedOnBoard) {
        StopArrivalState<T> arrival = this.arrivals.get(round, stop);
        if (!stopReachedOnBoard) {
            if (arrival.arrivedByAccessOnStreet()) {
                return this.newAccessViewByExactArrivalTime(round, arrival.time(), arrival.accessPathOnStreet());
            }
            if (arrival.arrivedByTransfer()) {
                return new Transfer<T>(round, stop, arrival, this);
            }
        }
        if (arrival.arrivedByAccessOnBoard()) {
            return this.newAccessViewByExactArrivalTime(round, arrival.onBoardArrivalTime(), arrival.accessPathOnBoard());
        }
        if (arrival.arrivedByTransit()) {
            return new Transit<T>(round, stop, arrival, this);
        }
        throw new IllegalStateException("Unknown arrival: " + arrival);
    }

    public ArrivalView<T> stop(int round, int stop, @Nonnull Transit<T> nextTransitLeg) {
        StopArrivalState<T> arrival = this.arrivals.get(round, stop);
        if (arrival.arrivedByAccessOnStreet()) {
            return this.newAccessView(round, arrival.accessPathOnStreet(), nextTransitLeg);
        }
        if (arrival.arrivedByTransfer()) {
            return new Transfer<T>(round, stop, arrival, this);
        }
        if (arrival.arrivedByAccessOnBoard()) {
            return this.newAccessView(round, arrival.accessPathOnBoard(), nextTransitLeg);
        }
        if (arrival.arrivedByTransit()) {
            return new Transit<T>(round, stop, arrival, this);
        }
        throw new IllegalStateException("Unknown arrival: " + arrival);
    }

    private ArrivalView<T> newAccessView(int round, RaptorAccessEgress accessPath, Transit<T> transit) {
        int transitDepartureTime = transit.boardTime();
        int boardSlack = this.boardSlackProvider.applyAsInt(transit.trip().pattern());
        int preferredDepartureTime = this.transitCalculator.minusDuration(transitDepartureTime, boardSlack + accessPath.durationInSeconds());
        return this.newAccessViewByPreferredDepartureTime(round, preferredDepartureTime, accessPath);
    }

    private ArrivalView<T> newAccessViewByPreferredDepartureTime(int round, int preferredDepartureTime, RaptorAccessEgress accessPath) {
        int departureTime = this.transitCalculator.departureTime(accessPath, preferredDepartureTime);
        if (departureTime == -1999000000) {
            throw new IllegalStateException("The departureTime is not found");
        }
        int arrivalTime = this.transitCalculator.plusDuration(departureTime, accessPath.durationInSeconds());
        return this.newAccessViewByExactArrivalTime(round, arrivalTime, accessPath);
    }

    private ArrivalView<T> newAccessViewByExactArrivalTime(int round, int exactArrivalTimeTime, RaptorAccessEgress accessPath) {
        return new Access(round, exactArrivalTimeTime, accessPath);
    }
}

