/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.stoparrivals;

import java.util.Collection;
import java.util.List;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.DestinationArrivalListener;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.DefaultStopArrivalState;

final class EgressStopArrivalState<T extends RaptorTripSchedule>
extends DefaultStopArrivalState<T> {
    private final int round;
    private final int stop;
    private final RaptorAccessEgress[] egressPaths;
    private final DestinationArrivalListener callback;

    EgressStopArrivalState(int stop, int round, Collection<RaptorAccessEgress> egressPaths, DestinationArrivalListener transitCallback) {
        this.round = round;
        this.stop = stop;
        this.egressPaths = egressPaths.toArray(new RaptorAccessEgress[0]);
        this.callback = transitCallback;
    }

    public int round() {
        return this.round;
    }

    public int stop() {
        return this.stop;
    }

    @Override
    public void arriveByTransit(int arrivalTime, int boardStop, int boardTime, T trip) {
        super.arriveByTransit(arrivalTime, boardStop, boardTime, trip);
        for (RaptorAccessEgress egressPath : this.egressPaths) {
            this.callback.newDestinationArrival(this.round, arrivalTime, true, egressPath);
        }
    }

    @Override
    public void transferToStop(int fromStop, int arrivalTime, RaptorTransfer transferPath) {
        super.transferToStop(fromStop, arrivalTime, transferPath);
        for (RaptorAccessEgress egressPath : this.egressPaths) {
            if (!egressPath.stopReachedOnBoard()) continue;
            this.callback.newDestinationArrival(this.round, arrivalTime, false, egressPath);
        }
    }

    @Override
    void setAccessTime(int time, boolean isBestTimeOverall, boolean onBoard) {
        super.setAccessTime(time, isBestTimeOverall, onBoard);
        for (RaptorAccessEgress egressPath : this.egressPaths) {
            this.callback.newDestinationArrival(this.round, time, onBoard, egressPath);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder builder = ToStringBuilder.of(EgressStopArrivalState.class).addNum("stop", this.stop).addNum("round", this.round);
        this.toStringAddBody(builder);
        builder.addCol("egressPaths", List.of(this.egressPaths));
        return builder.toString();
    }
}

