/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.debug;

import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.raptor.rangeraptor.internalapi.DebugHandler;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.raptor.rangeraptor.standard.stoparrivals.view.StopsCursor;

class StateDebugger<T extends RaptorTripSchedule> {
    private final StopsCursor<T> cursor;
    private final RoundProvider roundProvider;
    private final DebugHandler<ArrivalView<?>> debugHandlerStopArrivals;

    StateDebugger(StopsCursor<T> cursor, RoundProvider roundProvider, DebugHandlerFactory<T> dFactory) {
        this.cursor = cursor;
        this.roundProvider = roundProvider;
        this.debugHandlerStopArrivals = dFactory.debugStopArrival();
    }

    void acceptAccessPath(int stop, RaptorAccessEgress access) {
        if (this.isDebug(stop)) {
            this.debugHandlerStopArrivals.accept(this.cursor.access(this.round(), stop, access));
        }
    }

    void rejectAccessPath(RaptorAccessEgress accessPath, int arrivalTime) {
        if (this.isDebug(accessPath.stop())) {
            this.reject(this.cursor.fictiveAccess(this.round(), accessPath, arrivalTime));
        }
    }

    void dropOldStateAndAcceptNewOnBoardArrival(int stop, boolean newBestOverall, Runnable body) {
        if (this.isDebug(stop)) {
            this.drop(stop, true, newBestOverall);
            body.run();
            this.accept(stop, true);
        } else {
            body.run();
        }
    }

    void dropOldStateAndAcceptNewOnStreetArrival(int stop, Runnable body) {
        if (this.isDebug(stop)) {
            this.drop(stop, false, true);
            body.run();
            this.accept(stop, false);
        } else {
            body.run();
        }
    }

    void rejectTransit(int alightStop, int alightTime, T trip, int boardStop, int boardTime) {
        if (this.isDebug(alightStop)) {
            this.reject(this.cursor.fictiveTransit(this.round(), alightStop, alightTime, trip, boardStop, boardTime));
        }
    }

    void rejectTransfer(int fromStop, RaptorTransfer transfer, int toStop, int arrivalTime) {
        if (this.isDebug(transfer.stop())) {
            this.reject(this.cursor.fictiveTransfer(this.round(), fromStop, transfer, toStop, arrivalTime));
        }
    }

    private boolean isDebug(int stop) {
        return this.debugHandlerStopArrivals.isDebug(stop);
    }

    private void accept(int stop, boolean stopReachedOnBoard) {
        this.debugHandlerStopArrivals.accept(this.cursor.stop(this.round(), stop, stopReachedOnBoard));
    }

    private void drop(int stop, boolean onBoard, boolean newBestOverall) {
        int round = this.round();
        if (onBoard) {
            if (this.cursor.reachedOnBoard(round, stop)) {
                this.dropExistingArrival(round, stop, onBoard);
            }
            if (newBestOverall && this.cursor.reachedOnStreet(round, stop)) {
                this.dropExistingArrival(round, stop, false);
            }
        } else if (this.cursor.reachedOnStreet(round, stop)) {
            this.dropExistingArrival(round, stop, onBoard);
        }
    }

    private void reject(ArrivalView<T> arrival) {
        this.debugHandlerStopArrivals.reject(arrival, null, null);
    }

    private void dropExistingArrival(int round, int stop, boolean onBoard) {
        this.debugHandlerStopArrivals.drop(this.cursor.stop(round, stop, onBoard), null, null);
    }

    private int round() {
        return this.roundProvider.round();
    }
}

