/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.configure;

import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.rangeraptor.context.SearchContext;

class VerifyRequestIsValid {
    private final SearchContext<?> context;

    VerifyRequestIsValid(SearchContext<?> context) {
        this.context = context;
    }

    void verify() {
        this.verifyMinTravelDurationIsOneIterationOnly();
    }

    private void verifyMinTravelDurationIsOneIterationOnly() {
        this.verify(this.minTravelDurationStrategy() && !this.oneIteration(), "The profile %s is only defined for one iteration.", new Object[]{this.profile()});
    }

    private void verify(boolean condition, String format, Object ... args) {
        if (condition) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }

    private RaptorProfile profile() {
        return this.context.profile();
    }

    private boolean minTravelDurationStrategy() {
        return this.profile().is(RaptorProfile.MIN_TRAVEL_DURATION);
    }

    private boolean oneIteration() {
        return this.context.calculator().oneIterationOnly();
    }
}

