/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard.besttimes;

import java.util.Collection;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.TransitArrival;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.BestTimes;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.SimpleBestNumberOfTransfers;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.UnknownPathFactory;
import org.opentripplanner.raptor.rangeraptor.standard.internalapi.StopArrivalsState;

public class BestTimesOnlyStopArrivalsState<T extends RaptorTripSchedule>
implements StopArrivalsState<T> {
    private final BestTimes bestTimes;
    private final SimpleBestNumberOfTransfers bestNumberOfTransfers;
    private final UnknownPathFactory<T> unknownPathFactory;

    public BestTimesOnlyStopArrivalsState(BestTimes bestTimes, SimpleBestNumberOfTransfers bestNumberOfTransfers, UnknownPathFactory<T> unknownPathFactory) {
        this.bestTimes = bestTimes;
        this.bestNumberOfTransfers = bestNumberOfTransfers;
        this.unknownPathFactory = unknownPathFactory;
    }

    @Override
    public void setAccessTime(int arrivalTime, RaptorAccessEgress access, boolean bestTime) {
        this.bestNumberOfTransfers.arriveAtStop(access.stop());
    }

    @Override
    public int bestTimePreviousRound(int stop) {
        return this.bestTimes.time(stop);
    }

    @Override
    public void setNewBestTransitTime(int stop, int alightTime, T trip, int boardStop, int boardTime, boolean newBestOverall) {
        this.bestNumberOfTransfers.arriveAtStop(stop);
    }

    @Override
    public void setNewBestTransferTime(int fromStop, int arrivalTime, RaptorTransfer transfer) {
        this.bestNumberOfTransfers.arriveAtStop(transfer.stop());
    }

    @Override
    public TransitArrival<T> previousTransit(int boardStopIndex) {
        throw new IllegalStateException("The implementation of this interface is not compatible with the requestconfiguration. For example the BestTimesOnlyStopArrivalsState can not be used with constrained transfers.");
    }

    @Override
    public Collection<RaptorPath<T>> extractPaths() {
        return this.unknownPathFactory.extractPaths();
    }
}

