/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard;

import java.util.Collection;
import java.util.function.Supplier;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.SingleCriteriaStopArrivals;
import org.opentripplanner.raptor.rangeraptor.standard.besttimes.BestTimes;

public class StdRaptorWorkerResult<T extends RaptorTripSchedule>
implements RaptorWorkerResult<T> {
    private final BestTimes bestTimes;
    private final Supplier<Collection<RaptorPath<T>>> pathSupplier;
    private final Supplier<SingleCriteriaStopArrivals> bestNumberOfTransfersSupplier;
    private Collection<RaptorPath<T>> paths = null;

    public StdRaptorWorkerResult(BestTimes bestTimes, Supplier<Collection<RaptorPath<T>>> pathSupplier, Supplier<SingleCriteriaStopArrivals> bestNumberOfTransfersSupplier) {
        this.bestTimes = bestTimes;
        this.pathSupplier = pathSupplier;
        this.bestNumberOfTransfersSupplier = bestNumberOfTransfersSupplier;
    }

    @Override
    public Collection<RaptorPath<T>> extractPaths() {
        if (this.paths == null) {
            this.paths = this.pathSupplier.get();
        }
        return this.paths;
    }

    @Override
    public SingleCriteriaStopArrivals extractBestOverallArrivals() {
        return this.bestTimes.extractBestOverallArrivals();
    }

    @Override
    public SingleCriteriaStopArrivals extractBestTransitArrivals() {
        return this.bestTimes.extractBestTransitArrivals();
    }

    @Override
    public SingleCriteriaStopArrivals extractBestNumberOfTransfers() {
        return this.bestNumberOfTransfersSupplier.get();
    }

    @Override
    public boolean isDestinationReached() {
        return !this.extractPaths().isEmpty();
    }
}

