/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.standard;

import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.TransitArrival;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.standard.StdWorkerState;
import org.opentripplanner.raptor.rangeraptor.support.TimeBasedBoardingSupport;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorRoute;

public final class MinTravelDurationRoutingStrategy<T extends RaptorTripSchedule>
implements RoutingStrategy<T> {
    private static final int NOT_SET = -1;
    private final StdWorkerState<T> state;
    private final TimeBasedBoardingSupport<T> boardingSupport;
    private final TransitCalculator<T> calculator;
    private int onTripIndex;
    private int onTripBoardTime;
    private int onTripBoardStop;
    private T onTrip;
    private int onTripTimeShift;
    private int iterationDepartureTime;

    public MinTravelDurationRoutingStrategy(StdWorkerState<T> state, TimeBasedBoardingSupport<T> boardingSupport, TransitCalculator<T> calculator, WorkerLifeCycle lifeCycle) {
        this.state = state;
        this.boardingSupport = boardingSupport;
        this.calculator = calculator;
        lifeCycle.onSetupIteration(it -> {
            this.iterationDepartureTime = it;
        });
    }

    @Override
    public void setAccessToStop(RaptorAccessEgress accessPath, int departureTime) {
        this.state.setAccessToStop(accessPath, this.iterationDepartureTime);
    }

    @Override
    public void prepareForTransitWith(RaptorRoute<T> route) {
        this.boardingSupport.prepareForTransitWith(route.timetable());
        this.onTripIndex = -1;
        this.onTripBoardTime = -1;
        this.onTripBoardStop = -1;
        this.onTrip = null;
        this.onTripTimeShift = -1;
    }

    @Override
    public void alightOnlyRegularTransferExist(int stopIndex, int stopPos, int alightSlack) {
        this.alight(stopIndex, stopPos, alightSlack);
    }

    @Override
    public void alightConstrainedTransferExist(int stopIndex, int stopPos, int alightSlack) {
        this.alight(stopIndex, stopPos, 0);
    }

    @Override
    public void boardWithRegularTransfer(int stopIndex, int stopPos, int boardSlack) {
        int prevArrivalTime = this.prevArrivalTime(stopIndex);
        this.boardingSupport.searchRegularTransfer(prevArrivalTime, stopPos, boardSlack, this.onTripIndex).boardWithFallback(boarding -> this.board(stopIndex, (RaptorBoardOrAlightEvent<T>)boarding), emptyBoarding -> this.boardSameTrip(emptyBoarding.earliestBoardTime(), stopPos, stopIndex));
    }

    @Override
    public void boardWithConstrainedTransfer(int stopIndex, int stopPos, int boardSlack, RaptorConstrainedBoardingSearch<T> txSearch) {
        this.boardWithRegularTransfer(stopIndex, stopPos, 0);
    }

    private void alight(int stopIndex, int stopPos, int alightSlackApplied) {
        if (this.onTripIndex != -1) {
            int stopArrivalTime0 = this.calculator.stopArrivalTime(this.onTrip, stopPos, alightSlackApplied);
            int stopArrivalTime = stopArrivalTime0 - this.onTripTimeShift;
            this.state.transitToStop(stopIndex, stopArrivalTime, this.onTripBoardStop, this.onTripBoardTime, this.onTrip);
        }
    }

    private void board(int stopIndex, RaptorBoardOrAlightEvent<T> boarding) {
        this.onTripIndex = boarding.tripIndex();
        this.onTrip = boarding.trip();
        this.onTripBoardTime = boarding.earliestBoardTime();
        this.onTripBoardStop = stopIndex;
        this.onTripTimeShift = boarding.time() - this.onTripBoardTime;
    }

    private void boardSameTrip(int earliestBoardTime, int stopPos, int stopIndex) {
        if (this.onTripIndex == -1) {
            return;
        }
        int tripBoardingTime = this.onTrip.departure(stopPos);
        if (this.calculator.isAfter(earliestBoardTime, tripBoardingTime)) {
            return;
        }
        int tripTimeShift = tripBoardingTime - earliestBoardTime;
        if (this.calculator.isBefore(tripTimeShift, this.onTripTimeShift)) {
            return;
        }
        this.onTripBoardTime = earliestBoardTime;
        this.onTripBoardStop = stopIndex;
        this.onTripTimeShift = tripTimeShift;
    }

    private int prevArrivalTime(int stopIndex) {
        return this.state.bestTimePreviousRound(stopIndex);
    }

    private TransitArrival<T> previousTransitArrival(int boardStopIndex) {
        return this.state.previousTransit(boardStopIndex);
    }
}

