/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.path;

import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.api.view.TransitPathView;
import org.opentripplanner.raptor.path.PathBuilder;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.path.BoardAndAlightTimeSearch;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrival;
import org.opentripplanner.raptor.rangeraptor.path.PathMapper;
import org.opentripplanner.raptor.rangeraptor.transit.TripTimesSearch;
import org.opentripplanner.raptor.spi.BoardAndAlightTime;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;

public final class ReversePathMapper<T extends RaptorTripSchedule>
implements PathMapper<T> {
    private final RaptorSlackProvider slackProvider;
    private final RaptorCostCalculator<T> costCalculator;
    private final RaptorStopNameResolver stopNameResolver;
    private final BoardAndAlightTimeSearch tripSearch;
    private final RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch;
    private int iterationDepartureTime = -1;

    public ReversePathMapper(RaptorSlackProvider slackProvider, RaptorCostCalculator<T> costCalculator, RaptorStopNameResolver stopNameResolver, RaptorPathConstrainedTransferSearch<T> transferConstraintsSearch, WorkerLifeCycle lifeCycle, boolean useApproximateTripTimesSearch) {
        this.slackProvider = slackProvider;
        this.costCalculator = costCalculator;
        this.stopNameResolver = stopNameResolver;
        this.transferConstraintsSearch = transferConstraintsSearch;
        this.tripSearch = ReversePathMapper.tripTimesSearch(useApproximateTripTimesSearch);
        lifeCycle.onSetupIteration(this::setRangeRaptorIterationDepartureTime);
    }

    @Override
    public RaptorPath<T> mapToPath(DestinationArrival<T> destinationArrival) {
        PathBuilder<T> pathBuilder = PathBuilder.tailPathBuilder(this.slackProvider, destinationArrival.arrivalTime(), this.costCalculator, this.stopNameResolver, this.transferConstraintsSearch);
        ArrivalView<T> arrival = destinationArrival.previous();
        pathBuilder.access(destinationArrival.egressPath().egress());
        while (true) {
            switch (arrival.arrivedBy()) {
                case ACCESS: {
                    pathBuilder.egress(arrival.accessPath().access());
                    return pathBuilder.build();
                }
                case TRANSIT: {
                    BoardAndAlightTime times = this.tripSearch.find(arrival);
                    TransitPathView<T> transit = arrival.transitPath();
                    pathBuilder.transit(transit.trip(), times);
                    break;
                }
                case TRANSFER: {
                    pathBuilder.transfer(arrival.transfer(), arrival.previous().stop());
                    break;
                }
                case EGRESS: {
                    throw new IllegalStateException("Unexpected arrival: " + arrival);
                }
            }
            arrival = arrival.previous();
        }
    }

    private static BoardAndAlightTimeSearch tripTimesSearch(boolean useApproximateTimeSearch) {
        return useApproximateTimeSearch ? TripTimesSearch::findTripReverseSearchApproximateTime : TripTimesSearch::findTripReverseSearch;
    }

    private void setRangeRaptorIterationDepartureTime(int iterationDepartureTime) {
        this.iterationDepartureTime = iterationDepartureTime;
    }
}

