/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.path;

import javax.annotation.Nonnull;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.util.paretoset.ParetoComparator;

public class PathParetoSetComparators {
    private PathParetoSetComparators() {
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> paretoComparator(boolean includeCost, boolean includeTimetable, boolean preferLateArrival, SearchDirection searchDirection, RelaxFunction relaxC1) {
        boolean preferLatestDeparture;
        boolean includeRelaxedCost = includeCost && !relaxC1.isNormal();
        boolean bl = preferLatestDeparture = preferLateArrival != searchDirection.isInReverse();
        if (includeRelaxedCost) {
            if (includeTimetable) {
                return PathParetoSetComparators.comparatorTimetableAndRelaxedC1(relaxC1);
            }
            if (preferLateArrival) {
                return PathParetoSetComparators.comparatorDepartureTimeAndRelaxedC1(relaxC1);
            }
            return PathParetoSetComparators.comparatorArrivalTimeAndRelaxedC1(relaxC1);
        }
        if (includeCost) {
            if (includeTimetable) {
                return PathParetoSetComparators.comparatorTimetableAndC1();
            }
            if (preferLatestDeparture) {
                return PathParetoSetComparators.comparatorDepartureTimeAndC1();
            }
            return PathParetoSetComparators.comparatorWithC1();
        }
        if (includeTimetable) {
            return PathParetoSetComparators.comparatorTimetable();
        }
        if (preferLatestDeparture) {
            return PathParetoSetComparators.comparatorStandardDepartureTime();
        }
        return PathParetoSetComparators.comparatorStandardArrivalTime();
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorStandardArrivalTime() {
        return (l, r) -> RaptorPath.compareArrivalTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorStandardDepartureTime() {
        return (l, r) -> RaptorPath.compareDepartureTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorTimetable() {
        return (l, r) -> RaptorPath.compareIterationDepartureTime(l, r) || RaptorPath.compareArrivalTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorTimetableAndC1() {
        return (l, r) -> RaptorPath.compareIterationDepartureTime(l, r) || RaptorPath.compareArrivalTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r) || RaptorPath.compareDuration(l, r) || RaptorPath.compareC1(l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorTimetableAndRelaxedC1(@Nonnull RelaxFunction relaxCost) {
        return (l, r) -> RaptorPath.compareIterationDepartureTime(l, r) || RaptorPath.compareArrivalTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r) || RaptorPath.compareDuration(l, r) || RaptorPath.compareC1(relaxCost, l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorWithC1() {
        return (l, r) -> RaptorPath.compareArrivalTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r) || RaptorPath.compareDuration(l, r) || RaptorPath.compareC1(l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorDepartureTimeAndC1() {
        return (l, r) -> RaptorPath.compareDepartureTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r) || RaptorPath.compareDuration(l, r) || RaptorPath.compareC1(l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorArrivalTimeAndRelaxedC1(RelaxFunction relaxCost) {
        return (l, r) -> RaptorPath.compareArrivalTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r) || RaptorPath.compareDuration(l, r) || RaptorPath.compareC1(relaxCost, l, r);
    }

    public static <T extends RaptorTripSchedule> ParetoComparator<RaptorPath<T>> comparatorDepartureTimeAndRelaxedC1(RelaxFunction relaxCost) {
        return (l, r) -> RaptorPath.compareDepartureTime(l, r) || RaptorPath.compareNumberOfTransfers(l, r) || RaptorPath.compareDuration(l, r) || RaptorPath.compareC1(relaxCost, l, r);
    }
}

