/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.c2;

import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.AccessPathView;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.c2.AbstractStopArrivalC2;

final class AccessStopArrivalC2<T extends RaptorTripSchedule>
extends AbstractStopArrivalC2<T> {
    private final RaptorAccessEgress access;

    AccessStopArrivalC2(int departureTime, RaptorAccessEgress access) {
        super(access.stop(), departureTime, access.durationInSeconds(), access.numberOfRides(), access.generalizedCost(), 0);
        this.access = access;
    }

    @Override
    public PathLegType arrivedBy() {
        return PathLegType.ACCESS;
    }

    @Override
    public AccessPathView accessPath() {
        return () -> this.access;
    }

    @Override
    public AbstractStopArrivalC2<T> timeShiftNewArrivalTime(int newRequestedArrivalTime) {
        int newArrivalTime = this.access.latestArrivalTime(newRequestedArrivalTime);
        if (newArrivalTime == -1999000000) {
            throw new IllegalStateException("The arrival should not have been accepted if it does not have a legal arrival-time.");
        }
        if (newArrivalTime == this.arrivalTime()) {
            return this;
        }
        int newDepartureTime = newArrivalTime - this.access.durationInSeconds();
        return new AccessStopArrivalC2<T>(newDepartureTime, this.access);
    }

    @Override
    public boolean arrivedOnBoard() {
        return this.access.stopReachedOnBoard();
    }
}

