/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.c1;

import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.AccessPathView;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrival;

final class AccessStopArrival<T extends RaptorTripSchedule>
extends McStopArrival<T> {
    private final RaptorAccessEgress access;

    AccessStopArrival(int departureTime, RaptorAccessEgress access) {
        super(access.stop(), departureTime, access.durationInSeconds(), access.generalizedCost(), access.numberOfRides());
        this.access = access;
    }

    @Override
    public int c2() {
        throw new UnsupportedOperationException("C2 is not available for the C1 implementation");
    }

    @Override
    public PathLegType arrivedBy() {
        return PathLegType.ACCESS;
    }

    @Override
    public AccessPathView accessPath() {
        return () -> this.access;
    }

    @Override
    public McStopArrival<T> timeShiftNewArrivalTime(int newRequestedArrivalTime) {
        int newArrivalTime = this.access.latestArrivalTime(newRequestedArrivalTime);
        if (newArrivalTime == -1999000000) {
            throw new IllegalStateException("The arrival should not have been accepted if it does not have a legal arrival-time.");
        }
        if (newArrivalTime == this.arrivalTime()) {
            return this;
        }
        int newDepartureTime = newArrivalTime - this.access.durationInSeconds();
        return new AccessStopArrival<T>(newDepartureTime, this.access);
    }

    @Override
    public boolean arrivedOnBoard() {
        return this.access.stopReachedOnBoard();
    }
}

