/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals;

import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.api.view.ArrivalView;

public abstract class McStopArrival<T extends RaptorTripSchedule>
implements ArrivalView<T> {
    private final McStopArrival<T> previous;
    private final int paretoRound;
    private final int stop;
    private final int arrivalTime;
    private final int travelDuration;
    private final int c1;

    protected McStopArrival(McStopArrival<T> previous, int paretoRoundIncrement, int stop, int arrivalTime, int c1) {
        this.previous = previous;
        this.paretoRound = previous.paretoRound + paretoRoundIncrement;
        this.stop = stop;
        this.arrivalTime = arrivalTime;
        this.travelDuration = previous.travelDuration() + (arrivalTime - previous.arrivalTime());
        this.c1 = c1;
    }

    protected McStopArrival(int stop, int departureTime, int travelDuration, int initialC1, int paretoRound) {
        this.previous = null;
        this.paretoRound = paretoRound;
        this.stop = stop;
        this.arrivalTime = departureTime + travelDuration;
        this.travelDuration = travelDuration;
        this.c1 = initialC1;
    }

    @Override
    public final int stop() {
        return this.stop;
    }

    @Override
    public final int round() {
        return (this.paretoRound + 1) / 2;
    }

    protected final int paretoRound() {
        return this.paretoRound;
    }

    @Override
    public final int arrivalTime() {
        return this.arrivalTime;
    }

    @Override
    public final int c1() {
        return this.c1;
    }

    @Override
    public final McStopArrival<T> previous() {
        return this.previous;
    }

    public final int travelDuration() {
        return this.travelDuration;
    }

    public McStopArrival<T> timeShiftNewArrivalTime(int newArrivalTime) {
        throw new UnsupportedOperationException("No accessEgress for transfer stop arrival");
    }

    public final int hashCode() {
        throw new IllegalStateException("Avoid using hashCode() and equals() for this class.");
    }

    public final boolean equals(Object o) {
        throw new IllegalStateException("Avoid using hashCode() and equals() for this class.");
    }

    public String toString() {
        return this.asString();
    }

    protected final int previousStop() {
        return this.previous.stop;
    }

    protected static boolean compareBase(McStopArrival<?> l, McStopArrival<?> r) {
        return l.arrivalTime() < r.arrivalTime() || l.paretoRound() < r.paretoRound() || l.c1() < r.c1();
    }

    protected static boolean relaxedCompareBase(RelaxFunction relaxC1, McStopArrival<?> l, McStopArrival<?> r) {
        return l.arrivalTime() < r.arrivalTime() || l.paretoRound() < r.paretoRound() || l.c1() < relaxC1.relax(r.c1());
    }

    protected static boolean compareArrivedOnBoard(McStopArrival<?> l, McStopArrival<?> r) {
        return l.arrivedOnBoard() && !r.arrivedOnBoard();
    }
}

