/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria;

import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.raptor.rangeraptor.multicriteria.McRangeRaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrival;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.PatternRide;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.PatternRideFactory;
import org.opentripplanner.raptor.rangeraptor.support.TimeBasedBoardingSupport;
import org.opentripplanner.raptor.spi.RaptorBoardOrAlightEvent;
import org.opentripplanner.raptor.spi.RaptorConstrainedBoardingSearch;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorRoute;
import org.opentripplanner.raptor.util.paretoset.ParetoSet;

public final class MultiCriteriaRoutingStrategy<T extends RaptorTripSchedule, R extends PatternRide<T>>
implements RoutingStrategy<T> {
    private final McRangeRaptorWorkerState<T> state;
    private final TimeBasedBoardingSupport<T> boardingSupport;
    private final PatternRideFactory<T, R> patternRideFactory;
    private final ParetoSet<R> patternRides;
    private final RaptorCostCalculator<T> generalizedCostCalculator;
    private final SlackProvider slackProvider;

    public MultiCriteriaRoutingStrategy(McRangeRaptorWorkerState<T> state, TimeBasedBoardingSupport<T> boardingSupport, PatternRideFactory<T, R> patternRideFactory, RaptorCostCalculator<T> generalizedCostCalculator, SlackProvider slackProvider, ParetoSet<R> patternRides) {
        this.state = state;
        this.boardingSupport = boardingSupport;
        this.patternRideFactory = patternRideFactory;
        this.generalizedCostCalculator = generalizedCostCalculator;
        this.slackProvider = slackProvider;
        this.patternRides = patternRides;
    }

    @Override
    public void setAccessToStop(RaptorAccessEgress accessPath, int departureTime) {
        this.state.setAccessToStop(accessPath, departureTime);
    }

    @Override
    public void prepareForTransitWith(RaptorRoute<T> route) {
        this.boardingSupport.prepareForTransitWith(route.timetable());
        this.patternRideFactory.prepareForTransitWith(route.pattern());
        this.patternRides.clear();
    }

    @Override
    public void alightOnlyRegularTransferExist(int stopIndex, int stopPos, int alightSlack) {
        for (PatternRide ride : this.patternRides) {
            this.state.transitToStop(ride, stopIndex, ride.trip().arrival(stopPos), alightSlack);
        }
    }

    @Override
    public void alightConstrainedTransferExist(int stopIndex, int stopPos, int alightSlack) {
        this.alightOnlyRegularTransferExist(stopIndex, stopPos, alightSlack);
    }

    @Override
    public void boardWithRegularTransfer(int stopIndex, int stopPos, int boardSlack) {
        for (McStopArrival<T> prevArrival : this.state.listStopArrivalsPreviousRound(stopIndex)) {
            this.boardWithRegularTransfer(prevArrival, stopIndex, stopPos, boardSlack);
        }
    }

    @Override
    public void boardWithConstrainedTransfer(int stopIndex, int stopPos, int boardSlack, RaptorConstrainedBoardingSearch<T> txSearch) {
        for (McStopArrival<T> prevArrival : this.state.listStopArrivalsPreviousRound(stopIndex)) {
            this.boardWithConstrainedTransfer(prevArrival, stopIndex, stopPos, boardSlack, txSearch);
        }
    }

    private void board(McStopArrival<T> prevArrival, int stopIndex, RaptorBoardOrAlightEvent<T> boarding) {
        T trip = boarding.trip();
        int boardTime = boarding.time();
        if (prevArrival.arrivedBy(PathLegType.ACCESS)) {
            int latestArrivalTime = boardTime - this.slackProvider.boardSlack(trip.pattern().slackIndex());
            prevArrival = prevArrival.timeShiftNewArrivalTime(latestArrivalTime);
        }
        int boardC1 = this.calculateCostAtBoardTime(prevArrival, boarding);
        int relativeBoardC1 = boardC1 + this.calculateOnTripRelativeCost(boardTime, trip);
        R ride = this.patternRideFactory.createPatternRide(prevArrival, stopIndex, boarding.stopPositionInPattern(), boardTime, boardC1, relativeBoardC1, trip);
        this.patternRides.add(ride);
    }

    private void boardWithRegularTransfer(McStopArrival<T> prevArrival, int stopIndex, int stopPos, int boardSlack) {
        RaptorBoardOrAlightEvent<T> result = this.boardingSupport.searchRegularTransfer(prevArrival.arrivalTime(), stopPos, boardSlack);
        if (!result.empty()) {
            this.board(prevArrival, stopIndex, result);
        }
    }

    private void boardWithConstrainedTransfer(McStopArrival<T> prevArrival, int stopIndex, int stopPos, int boardSlack, RaptorConstrainedBoardingSearch<T> txSearch) {
        this.boardingSupport.searchConstrainedTransfer(prevArrival.mostRecentTransitArrival(), prevArrival.arrivalTime(), boardSlack, txSearch).boardWithFallback(boarding -> this.board(prevArrival, stopIndex, (RaptorBoardOrAlightEvent<T>)boarding), emptyBoarding -> this.boardWithRegularTransfer(prevArrival, stopIndex, stopPos, boardSlack));
    }

    private int calculateCostAtBoardTime(McStopArrival<T> prevArrival, RaptorBoardOrAlightEvent<T> boardEvent) {
        return prevArrival.c1() + this.generalizedCostCalculator.boardingCost(prevArrival.isFirstRound(), prevArrival.arrivalTime(), boardEvent.boardStopIndex(), boardEvent.time(), boardEvent.trip(), boardEvent.transferConstraint());
    }

    private int calculateOnTripRelativeCost(int boardTime, T tripSchedule) {
        return this.generalizedCostCalculator.onTripRelativeRidingCost(boardTime, tripSchedule);
    }
}

