/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria;

import gnu.trove.map.TIntObjectMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.raptor.rangeraptor.multicriteria.DebugStopArrivalsStatistics;
import org.opentripplanner.raptor.rangeraptor.multicriteria.StopArrivalParetoSet;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.ArrivalParetoSetComparatorFactory;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrival;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.rangeraptor.transit.AccessPaths;
import org.opentripplanner.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.util.BitSetIterator;

public final class McStopArrivals<T extends RaptorTripSchedule> {
    private final StopArrivalParetoSet<T>[] arrivals;
    private final BitSet touchedStops;
    private final ArrivalParetoSetComparatorFactory<McStopArrival<T>> comparatorFactory;
    private final DebugHandlerFactory<T> debugHandlerFactory;
    private final DebugStopArrivalsStatistics debugStats;

    public McStopArrivals(int nStops, EgressPaths egressPaths, AccessPaths accessPaths, DestinationArrivalPaths<T> paths, ArrivalParetoSetComparatorFactory<McStopArrival<T>> comparatorFactory, DebugHandlerFactory<T> debugHandlerFactory) {
        this.comparatorFactory = comparatorFactory;
        this.arrivals = new StopArrivalParetoSet[nStops];
        this.touchedStops = new BitSet(nStops);
        this.debugHandlerFactory = debugHandlerFactory;
        this.debugStats = new DebugStopArrivalsStatistics(debugHandlerFactory.debugLogger());
        this.initAccessArrivals(accessPaths.arrivedOnBoardByNumOfRides());
        this.glueTogetherEgressStopWithDestinationArrivals(egressPaths, paths);
    }

    public boolean reached(int stopIndex) {
        return this.arrivals[stopIndex] != null && !this.arrivals[stopIndex].isEmpty();
    }

    public int bestArrivalTime(int stopIndex) {
        return this.minInt(this.arrivals[stopIndex].stream(), McStopArrival::arrivalTime);
    }

    public boolean reachedByTransit(int stopIndex) {
        return this.arrivals[stopIndex] != null && this.arrivals[stopIndex].stream().anyMatch(a -> a.arrivedBy(PathLegType.TRANSIT));
    }

    public int bestTransitArrivalTime(int stopIndex) {
        return this.transitStopArrivalsMinInt(stopIndex, McStopArrival::arrivalTime);
    }

    public int smallestNumberOfTransfers(int stopIndex) {
        return this.transitStopArrivalsMinInt(stopIndex, ArrivalView::numberOfTransfers);
    }

    boolean updateExist() {
        return !this.touchedStops.isEmpty();
    }

    IntIterator stopsTouchedIterator() {
        return new BitSetIterator(this.touchedStops);
    }

    void addStopArrival(McStopArrival<T> arrival) {
        boolean added = this.findOrCreateSet(arrival.stop()).add(arrival);
        if (added) {
            this.touchedStops.set(arrival.stop());
        }
    }

    void debugStateInfo() {
        this.debugStats.debugStatInfo(this.arrivals);
    }

    public boolean hasArrivalsAfterMarker(int stop) {
        StopArrivalParetoSet<T> it = this.arrivals[stop];
        if (it == null) {
            return false;
        }
        return it.hasElementsAfterMarker();
    }

    Iterable<McStopArrival<T>> listArrivalsAfterMarker(int stop) {
        StopArrivalParetoSet<T> it = this.arrivals[stop];
        if (it == null) {
            return Collections::emptyIterator;
        }
        return it.elementsAfterMarker();
    }

    void clearTouchedStopsAndSetStopMarkers() {
        IntIterator it = this.stopsTouchedIterator();
        while (it.hasNext()) {
            this.arrivals[it.next()].markAtEndOfSet();
        }
        this.touchedStops.clear();
    }

    private StopArrivalParetoSet<T> findOrCreateSet(int stop) {
        if (this.arrivals[stop] == null) {
            this.arrivals[stop] = StopArrivalParetoSet.createStopArrivalSet(this.comparatorFactory.compareArrivalTimeRoundAndCost(), this.debugHandlerFactory.paretoSetStopArrivalListener(stop));
        }
        return this.arrivals[stop];
    }

    private void initAccessArrivals(TIntObjectMap<List<RaptorAccessEgress>> accessOnBoardByRides) {
        for (int round : accessOnBoardByRides.keys()) {
            for (RaptorAccessEgress access : (List)accessOnBoardByRides.get(round)) {
                int stop = access.stop();
                this.arrivals[stop] = StopArrivalParetoSet.createStopArrivalSet(this.comparatorFactory.compareArrivalTimeRoundCostAndOnBoardArrival(), this.debugHandlerFactory.paretoSetStopArrivalListener(stop));
            }
        }
    }

    private void glueTogetherEgressStopWithDestinationArrivals(EgressPaths egressPaths, DestinationArrivalPaths<T> paths) {
        egressPaths.byStop().forEachEntry((stop, list) -> {
            this.arrivals[stop] = StopArrivalParetoSet.createEgressStopArrivalSet(this.comparatorFactory.compareArrivalTimeRoundCostAndOnBoardArrival(), list, paths, this.debugHandlerFactory.paretoSetStopArrivalListener(stop));
            return true;
        });
    }

    private int transitStopArrivalsMinInt(int stopIndex, Function<McStopArrival<T>, Integer> mapper) {
        Stream<McStopArrival<T>> transitArrivals = this.arrivals[stopIndex].stream().filter(a -> a.arrivedBy(PathLegType.TRANSIT));
        return this.minInt(transitArrivals, mapper);
    }

    private int minInt(Stream<McStopArrival<T>> transitArrivals, Function<McStopArrival<T>, Integer> mapper) {
        return transitArrivals.mapToInt(mapper::apply).min().orElseThrow();
    }
}

