/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.multicriteria;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.multicriteria.McRaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.multicriteria.McStopArrivals;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrival;
import org.opentripplanner.raptor.rangeraptor.multicriteria.arrivals.McStopArrivalFactory;
import org.opentripplanner.raptor.rangeraptor.multicriteria.heuristic.HeuristicsProvider;
import org.opentripplanner.raptor.rangeraptor.multicriteria.ride.PatternRide;
import org.opentripplanner.raptor.rangeraptor.path.DestinationArrivalPaths;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.spi.IntIterator;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;

public final class McRangeRaptorWorkerState<T extends RaptorTripSchedule>
implements RaptorWorkerState<T> {
    private final McStopArrivals<T> arrivals;
    private final DestinationArrivalPaths<T> paths;
    private final HeuristicsProvider<T> heuristics;
    private final McStopArrivalFactory<T> stopArrivalFactory;
    private final List<McStopArrival<T>> arrivalsCache = new ArrayList<McStopArrival<T>>();
    private final RaptorCostCalculator<T> calculatorGeneralizedCost;
    private final RaptorTransitCalculator<T> transitCalculator;

    public McRangeRaptorWorkerState(McStopArrivals<T> arrivals, DestinationArrivalPaths<T> paths, HeuristicsProvider<T> heuristics, McStopArrivalFactory<T> stopArrivalFactory, RaptorCostCalculator<T> calculatorGeneralizedCost, RaptorTransitCalculator<T> transitCalculator, WorkerLifeCycle lifeCycle) {
        this.arrivals = arrivals;
        this.paths = paths;
        this.heuristics = heuristics;
        this.stopArrivalFactory = stopArrivalFactory;
        this.calculatorGeneralizedCost = calculatorGeneralizedCost;
        this.transitCalculator = transitCalculator;
        lifeCycle.onSetupIteration(ignore -> this.setupIteration());
        lifeCycle.onTransitsForRoundComplete(this::transitsForRoundComplete);
        lifeCycle.onTransfersForRoundComplete(this::transfersForRoundComplete);
    }

    @Override
    public boolean isNewRoundAvailable() {
        return this.arrivals.updateExist();
    }

    @Override
    public IntIterator stopsTouchedPreviousRound() {
        return this.arrivals.stopsTouchedIterator();
    }

    @Override
    public IntIterator stopsTouchedByTransitCurrentRound() {
        return this.arrivals.stopsTouchedIterator();
    }

    @Override
    public boolean isDestinationReachedInCurrentRound() {
        return this.paths.isReachedCurrentRound();
    }

    @Override
    public boolean isStopReachedInPreviousRound(int stopIndex) {
        return this.arrivals.hasArrivalsAfterMarker(stopIndex);
    }

    public void setAccessToStop(RaptorAccessEgress accessPath, int departureTime) {
        this.addStopArrival(this.stopArrivalFactory.createAccessStopArrival(departureTime, accessPath));
    }

    @Override
    public void transferToStops(int fromStop, Iterator<? extends RaptorTransfer> transfers) {
        Iterable<McStopArrival<T>> fromArrivals = this.arrivals.listArrivalsAfterMarker(fromStop);
        while (transfers.hasNext()) {
            this.transferToStop(fromArrivals, transfers.next());
        }
    }

    @Override
    public RaptorWorkerResult<T> results() {
        this.arrivals.debugStateInfo();
        return new McRaptorWorkerResult<T>(this.arrivals, this.paths);
    }

    Iterable<? extends McStopArrival<T>> listStopArrivalsPreviousRound(int stop) {
        return this.arrivals.listArrivalsAfterMarker(stop);
    }

    void transitToStop(PatternRide<T> ride, int alightStop, int alightTime, int alightSlack) {
        int stopArrivalTime = alightTime + alightSlack;
        if (this.exceedsTimeLimit(stopArrivalTime)) {
            return;
        }
        int c1 = this.calculateC1(ride, alightStop, alightTime, alightSlack);
        McStopArrival<T> transitState = this.stopArrivalFactory.createTransitStopArrival(ride, alightStop, stopArrivalTime, c1);
        this.arrivalsCache.add(transitState);
    }

    private void setupIteration() {
        this.arrivalsCache.clear();
        this.arrivals.clearTouchedStopsAndSetStopMarkers();
    }

    private void transitsForRoundComplete() {
        this.arrivals.clearTouchedStopsAndSetStopMarkers();
        this.commitCachedArrivals();
    }

    private void transfersForRoundComplete() {
        this.commitCachedArrivals();
    }

    private void transferToStop(Iterable<? extends McStopArrival<T>> fromArrivals, RaptorTransfer transfer) {
        int transferTimeInSeconds = transfer.durationInSeconds();
        for (McStopArrival<T> it : fromArrivals) {
            int arrivalTime = it.arrivalTime() + transferTimeInSeconds;
            if (this.exceedsTimeLimit(arrivalTime)) continue;
            this.arrivalsCache.add(this.stopArrivalFactory.createTransferStopArrival(it, transfer, arrivalTime));
        }
    }

    private void commitCachedArrivals() {
        for (McStopArrival<T> arrival : this.arrivalsCache) {
            this.addStopArrival(arrival);
        }
        this.arrivalsCache.clear();
    }

    private void addStopArrival(McStopArrival<T> arrival) {
        if (this.heuristics.rejectDestinationArrivalBasedOnHeuristic(arrival)) {
            return;
        }
        this.arrivals.addStopArrival(arrival);
    }

    private int calculateC1(PatternRide<T> ride, int alightStop, int alightTime, int alightSlack) {
        return this.calculatorGeneralizedCost.transitArrivalCost(ride.boardC1(), alightSlack, alightTime - ride.boardTime(), ride.trip(), alightStop);
    }

    private boolean exceedsTimeLimit(int time) {
        return this.transitCalculator.exceedsTimeLimit(time);
    }
}

