/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.debug;

import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.debug.DebugLogger;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.request.DebugRequest;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.api.view.PatternRideView;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerPathAdapter;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerPatternRideAdapter;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerStopArrivalAdapter;
import org.opentripplanner.raptor.rangeraptor.debug.ParetoSetDebugHandlerAdapter;
import org.opentripplanner.raptor.rangeraptor.internalapi.DebugHandler;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.util.paretoset.ParetoSetEventListener;

public class DebugHandlerFactory<T extends RaptorTripSchedule> {
    private final DebugHandler<ArrivalView<?>> stopHandler;
    private final DebugHandler<RaptorPath<?>> pathHandler;
    private final DebugHandler<PatternRideView<?, ?>> patternRideHandler;
    private final DebugLogger logger;

    public DebugHandlerFactory(DebugRequest request, WorkerLifeCycle lifeCycle) {
        this.stopHandler = this.isDebug(request.stopArrivalListener()) ? new DebugHandlerStopArrivalAdapter(request, lifeCycle) : null;
        this.pathHandler = this.isDebug(request.pathFilteringListener()) ? new DebugHandlerPathAdapter(request, lifeCycle) : null;
        this.patternRideHandler = this.isDebug(request.patternRideDebugListener()) ? new DebugHandlerPatternRideAdapter(request, lifeCycle) : null;
        this.logger = request.logger();
        lifeCycle.onRouteSearch(this.logger::setSearchDirection);
    }

    public boolean isDebugStopArrival() {
        return this.isDebug(this.stopHandler);
    }

    public DebugHandler<ArrivalView<?>> debugStopArrival() {
        return this.stopHandler;
    }

    @Nullable
    public ParetoSetEventListener<ArrivalView<T>> paretoSetStopArrivalListener(int stop) {
        return this.isDebugStopArrival(stop) ? new ParetoSetDebugHandlerAdapter(this.stopHandler) : null;
    }

    public boolean isDebugStopArrival(int stop) {
        return this.stopHandler != null && this.stopHandler.isDebug(stop);
    }

    @Nullable
    public ParetoSetEventListener<PatternRideView<?, ?>> paretoSetPatternRideListener() {
        return this.patternRideHandler == null ? null : new ParetoSetDebugHandlerAdapter(this.patternRideHandler);
    }

    @Nullable
    public ParetoSetDebugHandlerAdapter<RaptorPath<?>> paretoSetDebugPathListener() {
        return this.pathHandler == null ? null : new ParetoSetDebugHandlerAdapter(this.pathHandler);
    }

    @Nullable
    public DebugHandler<RaptorPath<?>> debugPathArrival() {
        return this.pathHandler;
    }

    public DebugLogger debugLogger() {
        return this.logger;
    }

    private boolean isDebug(Object handler) {
        return handler != null;
    }
}

