/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.debug.RaptorTimers;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripPattern;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.path.RaptorStopNameResolver;
import org.opentripplanner.raptor.api.request.DebugRequest;
import org.opentripplanner.raptor.api.request.MultiCriteriaRequest;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.api.request.SearchParams;
import org.opentripplanner.raptor.rangeraptor.debug.DebugHandlerFactory;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoundProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.SlackProvider;
import org.opentripplanner.raptor.rangeraptor.internalapi.WorkerLifeCycle;
import org.opentripplanner.raptor.rangeraptor.lifecycle.LifeCycleEventPublisher;
import org.opentripplanner.raptor.rangeraptor.lifecycle.LifeCycleSubscriptions;
import org.opentripplanner.raptor.rangeraptor.support.TimeBasedBoardingSupport;
import org.opentripplanner.raptor.rangeraptor.transit.AccessPaths;
import org.opentripplanner.raptor.rangeraptor.transit.EgressPaths;
import org.opentripplanner.raptor.rangeraptor.transit.ForwardRaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.ReverseRaptorTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.RoundTracker;
import org.opentripplanner.raptor.rangeraptor.transit.SlackProviderAdapter;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;

public class SearchContext<T extends RaptorTripSchedule> {
    private final RaptorRequest<T> request;
    protected final RaptorTransitDataProvider<T> transit;
    private final RaptorTransitCalculator<T> calculator;
    private final RaptorTuningParameters tuningParameters;
    private final RoundTracker roundTracker;
    private final DebugHandlerFactory<T> debugFactory;
    private final EgressPaths egressPaths;
    private final AccessPaths accessPaths;
    private final LifeCycleSubscriptions lifeCycleSubscriptions = new LifeCycleSubscriptions();
    private RaptorCostCalculator<T> costCalculator = null;

    public SearchContext(RaptorRequest<T> request, RaptorTuningParameters tuningParameters, RaptorTransitDataProvider<T> transit) {
        this.request = request;
        this.tuningParameters = tuningParameters;
        this.transit = transit;
        this.accessPaths = SearchContext.accessPaths(request);
        this.egressPaths = SearchContext.egressPaths(request);
        this.calculator = SearchContext.createCalculator(this.request, tuningParameters);
        this.roundTracker = new RoundTracker(this.nRounds(), request.searchParams().numberOfAdditionalTransfers(), this.lifeCycle());
        this.debugFactory = new DebugHandlerFactory(SearchContext.debugRequest(request), this.lifeCycle());
    }

    public AccessPaths accessPaths() {
        return this.accessPaths;
    }

    public EgressPaths egressPaths() {
        return this.egressPaths;
    }

    public int[] egressStops() {
        return this.egressPaths().stops();
    }

    public SearchParams searchParams() {
        return this.request.searchParams();
    }

    public RaptorProfile profile() {
        return this.request.profile();
    }

    public SearchDirection searchDirection() {
        return this.request.searchDirection();
    }

    public MultiCriteriaRequest<T> multiCriteria() {
        return this.request.multiCriteria();
    }

    public RaptorTransitDataProvider<T> transit() {
        return this.transit;
    }

    public RaptorTransitCalculator<T> calculator() {
        return this.calculator;
    }

    public SlackProvider slackProvider() {
        return SearchContext.createSlackProvider(this.searchDirection(), this.raptorSlackProvider(), this.lifeCycle());
    }

    public RaptorSlackProvider raptorSlackProvider() {
        return this.transit.slackProvider();
    }

    public ToIntFunction<RaptorTripPattern> boardSlackProvider() {
        return SearchContext.createBoardSlackProvider(this.searchDirection(), this.raptorSlackProvider());
    }

    @Nullable
    public RaptorCostCalculator<T> costCalculator() {
        if (this.costCalculator == null) {
            this.costCalculator = this.transit.multiCriteriaCostCalculator();
        }
        return this.costCalculator;
    }

    public DebugHandlerFactory<T> debugFactory() {
        return this.debugFactory;
    }

    public RaptorTimers performanceTimers() {
        return this.request.performanceTimers();
    }

    public int nStops() {
        return this.transit.numberOfStops();
    }

    public int nRounds() {
        if (this.request.searchParams().isMaxNumberOfTransfersSet()) {
            return this.request.searchParams().maxNumberOfTransfers() + 1;
        }
        return this.tuningParameters.maxNumberOfTransfers() + 1;
    }

    public RoundProvider roundProvider() {
        return this.roundTracker;
    }

    public WorkerLifeCycle lifeCycle() {
        return this.lifeCycleSubscriptions;
    }

    public LifeCycleEventPublisher createLifeCyclePublisher() {
        LifeCycleEventPublisher publisher = new LifeCycleEventPublisher(this.lifeCycleSubscriptions);
        this.lifeCycleSubscriptions.close();
        return publisher;
    }

    public boolean useConstrainedTransfers() {
        return this.request.useConstrainedTransfers();
    }

    public RaptorStopNameResolver stopNameResolver() {
        return this.transit.stopNameResolver();
    }

    public TimeBasedBoardingSupport<T> createTimeBasedBoardingSupport() {
        return new TimeBasedBoardingSupport<T>(this.accessPaths().hasTimeDependentAccess(), this.slackProvider(), this.calculator(), this.roundProvider(), this.lifeCycle());
    }

    static Collection<RaptorAccessEgress> accessOrEgressPaths(boolean getAccess, RaptorProfile profile, SearchParams searchParams) {
        Collection<RaptorAccessEgress> paths;
        Collection<RaptorAccessEgress> collection = paths = getAccess ? searchParams.accessPaths() : searchParams.egressPaths();
        if (profile.is(RaptorProfile.MULTI_CRITERIA)) {
            return paths;
        }
        HashMap<Integer, RaptorAccessEgress> bestTimePaths = new HashMap<Integer, RaptorAccessEgress>();
        for (RaptorAccessEgress it : paths) {
            RaptorAccessEgress existing = (RaptorAccessEgress)bestTimePaths.get(it.stop());
            if (existing != null && it.durationInSeconds() >= existing.durationInSeconds()) continue;
            bestTimePaths.put(it.stop(), it);
        }
        return List.copyOf(bestTimePaths.values());
    }

    private static <T extends RaptorTripSchedule> RaptorTransitCalculator<T> createCalculator(RaptorRequest<T> r, RaptorTuningParameters t) {
        SearchParams s = r.searchParams();
        return r.searchDirection().isForward() ? new ForwardRaptorTransitCalculator(s, t) : new ReverseRaptorTransitCalculator(s, t);
    }

    private static DebugRequest debugRequest(RaptorRequest<?> request) {
        return request.searchDirection().isForward() ? request.debug() : request.mutate().debug().reverseDebugRequest().build();
    }

    private static SlackProvider createSlackProvider(SearchDirection searchDirection, RaptorSlackProvider slackProvider, WorkerLifeCycle lifeCycle) {
        return searchDirection.isForward() ? SlackProviderAdapter.forwardSlackProvider(slackProvider, lifeCycle) : SlackProviderAdapter.reverseSlackProvider(slackProvider, lifeCycle);
    }

    private static ToIntFunction<RaptorTripPattern> createBoardSlackProvider(SearchDirection searchDirection, RaptorSlackProvider slackProvider) {
        return searchDirection.isForward() ? p -> slackProvider.boardSlack(p.slackIndex()) : p -> slackProvider.alightSlack(p.slackIndex());
    }

    private static AccessPaths accessPaths(RaptorRequest<?> request) {
        boolean forward = request.searchDirection().isForward();
        SearchParams params = request.searchParams();
        Collection<RaptorAccessEgress> paths = forward ? params.accessPaths() : params.egressPaths();
        return AccessPaths.create(paths, request.profile());
    }

    private static EgressPaths egressPaths(RaptorRequest<?> request) {
        boolean forward = request.searchDirection().isForward();
        SearchParams params = request.searchParams();
        Collection<RaptorAccessEgress> paths = forward ? params.egressPaths() : params.accessPaths();
        return EgressPaths.create(paths, request.profile());
    }
}

