/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.rangeraptor;

import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import org.opentripplanner.framework.lang.IntUtils;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.framework.text.Table;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.debug.DebugEvent;
import org.opentripplanner.raptor.api.debug.DebugLogger;
import org.opentripplanner.raptor.api.debug.DebugTopic;
import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.PathStringBuilder;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.api.view.PatternRideView;
import org.opentripplanner.raptor.rangeraptor.transit.TripTimesSearch;
import org.opentripplanner.raptor.spi.BoardAndAlightTime;

public class SystemErrDebugLogger
implements DebugLogger {
    private static final int NOT_SET = Integer.MIN_VALUE;
    private final boolean enableDebugLogging;
    private final boolean eventLoggingDryRun;
    private final NumberFormat numFormat = NumberFormat.getInstance(Locale.FRANCE);
    private final Table arrivalTable = Table.of().withAlights(Table.Align.Center, Table.Align.Center, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Left, Table.Align.Left).withHeaders("ARRIVAL", "LEG", "RND", "STOP", "ARRIVE", "COST", "TRIP", "DETAILS").withMinWidths(9, 7, 3, 5, 8, 9, 24, 0).build();
    private final Table pathTable = Table.of().withAlights(Table.Align.Center, Table.Align.Center, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Right, Table.Align.Left).withHeaders(">>> PATH", "TR", "FROM", "TO", "START", "END", "DURATION", "COST", "DETAILS").withMinWidths(9, 2, 5, 5, 8, 8, 8, 6, 0).build();
    private boolean forwardSearch = true;
    private int lastIterationTime = Integer.MIN_VALUE;
    private int lastRound = Integer.MIN_VALUE;
    private boolean printPathHeader = true;

    public SystemErrDebugLogger(boolean enableDebugLogging, boolean eventLoggingDryRun) {
        this.enableDebugLogging = enableDebugLogging;
        this.eventLoggingDryRun = eventLoggingDryRun;
    }

    public void stopArrivalLister(DebugEvent<ArrivalView<?>> e) {
        this.printIterationHeader(e.iterationStartTime());
        this.printRoundHeader(e.element().round());
        this.print(e.element(), e.action().toString(), e.reason());
        ArrivalView<?> byElement = e.rejectedDroppedByElement();
        if (e.action() == DebugEvent.Action.DROP && byElement != null) {
            this.print(byElement, "->by", "");
        }
    }

    public void patternRideLister(DebugEvent<PatternRideView<?, ?>> e) {
        this.printIterationHeader(e.iterationStartTime());
        this.printRoundHeader(e.element().prevArrival().round() + 1);
        this.print(e.element(), e.action().toString());
        PatternRideView<?, ?> byElement = e.rejectedDroppedByElement();
        if (e.action() == DebugEvent.Action.DROP && byElement != null) {
            this.print(byElement, "->by");
        }
    }

    public void pathFilteringListener(DebugEvent<RaptorPath<?>> e) {
        if (this.printPathHeader) {
            this.println();
            this.println(this.pathTable.headerRow());
            this.printPathHeader = false;
        }
        RaptorPath<?> p = e.element();
        AccessPathLeg<?> aLeg = p.accessLeg();
        EgressPathLeg<?> eLeg = p.egressLeg();
        this.println(this.pathTable.rowAsText(e.action().toString(), p.numberOfTransfers(), aLeg != null ? Integer.valueOf(aLeg.toStop()) : null, eLeg != null ? Integer.valueOf(eLeg.fromStop()) : null, aLeg != null ? TimeUtils.timeToStrLong(aLeg.fromTime()) : null, eLeg != null ? TimeUtils.timeToStrLong(eLeg.toTime()) : null, DurationUtils.durationToStr(p.durationInSeconds()), OtpNumberFormat.formatCostCenti(p.c1()), SystemErrDebugLogger.details(e.action().toString(), e.reason(), e.element().toString())));
    }

    @Override
    public boolean isEnabled() {
        return this.enableDebugLogging;
    }

    @Override
    public void setSearchDirection(boolean forward) {
        this.forwardSearch = forward;
    }

    @Override
    public void debug(DebugTopic topic, String message) {
        if (this.enableDebugLogging) {
            if (message.contains("\n")) {
                System.err.printf("%s\n%s", new Object[]{topic, message});
            } else {
                System.err.printf("%-16s | %s%n", new Object[]{topic, message});
            }
        }
    }

    private static String details(String action, String optReason, @Nullable String element) {
        StringBuilder buf = new StringBuilder();
        buf.append(action).append(": ").append(element);
        if (SystemErrDebugLogger.isNotBlank(optReason)) {
            buf.append("  # ").append(optReason);
        }
        return buf.toString();
    }

    private static int legDuration(ArrivalView<?> a) {
        return switch (a.arrivedBy()) {
            default -> throw new IncompatibleClassChangeError();
            case PathLegType.ACCESS -> a.accessPath().access().durationInSeconds();
            case PathLegType.TRANSFER -> a.transfer().durationInSeconds();
            case PathLegType.EGRESS -> a.egressPath().egress().durationInSeconds();
            case PathLegType.TRANSIT -> throw new IllegalStateException("Unsupported type: " + a.getClass());
        };
    }

    private static boolean isNotBlank(String text) {
        return StringUtils.hasValue(text);
    }

    private void printIterationHeader(int iterationTime) {
        if (iterationTime == this.lastIterationTime) {
            return;
        }
        this.lastIterationTime = iterationTime;
        this.lastRound = Integer.MIN_VALUE;
        this.printPathHeader = true;
        this.println("\n**  RUN RAPTOR FOR MINUTE: " + TimeUtils.timeToStrCompact(iterationTime) + "  **");
    }

    private void print(ArrivalView<?> a, String action, String optReason) {
        this.printPathHeader = true;
        String pattern = a.arrivedBy(PathLegType.TRANSIT) ? a.transitPath().trip().pattern().debugInfo() : "";
        this.println(this.arrivalTable.rowAsText(action, this.legType(a), a.round(), IntUtils.intToString(a.stop(), Integer.MIN_VALUE), TimeUtils.timeToStrLong(a.arrivalTime()), this.numFormat.format(a.c1()), pattern, SystemErrDebugLogger.details(action, optReason, this.path(a))));
    }

    private void print(PatternRideView<?, ?> p, String action) {
        this.println(this.arrivalTable.rowAsText(action, "OnRide", p.prevArrival().round() + 1, p.boardStopIndex(), TimeUtils.timeToStrLong(p.boardTime()), this.numFormat.format(p.relativeC1()), p.trip().pattern().debugInfo(), p.toString()));
    }

    private String path(ArrivalView<?> a) {
        return this.path(a, new PathStringBuilder(null)).summary(a.c1()).toString();
    }

    private PathStringBuilder path(ArrivalView<?> a, PathStringBuilder buf) {
        if (a.arrivedBy().not(PathLegType.ACCESS)) {
            this.path(a.previous(), buf);
        }
        switch (a.arrivedBy()) {
            case ACCESS: {
                buf.accessEgress(a.accessPath().access());
                break;
            }
            case TRANSIT: {
                String tripInfo = a.transitPath().trip().pattern().debugInfo();
                if (this.forwardSearch) {
                    BoardAndAlightTime t = TripTimesSearch.findTripForwardSearchApproximateTime(a);
                    buf.transit(tripInfo, t.boardTime(), t.alightTime());
                    break;
                }
                BoardAndAlightTime t = TripTimesSearch.findTripReverseSearchApproximateTime(a);
                buf.transit(tripInfo, t.alightTime(), t.boardTime());
                break;
            }
            case TRANSFER: {
                buf.walk(SystemErrDebugLogger.legDuration(a));
                break;
            }
            case EGRESS: {
                buf.accessEgress(a.egressPath().egress());
            }
        }
        return buf.stop(a.stop());
    }

    private void printRoundHeader(int round) {
        if (round == this.lastRound) {
            return;
        }
        this.lastRound = round;
        this.println();
        this.println(this.arrivalTable.headerRow());
    }

    private String legType(ArrivalView<?> a) {
        return switch (a.arrivedBy()) {
            default -> throw new IncompatibleClassChangeError();
            case PathLegType.ACCESS -> "Access";
            case PathLegType.TRANSIT -> "Transit";
            case PathLegType.TRANSFER -> "Walk";
            case PathLegType.EGRESS -> "Egress";
        };
    }

    private void println() {
        if (!this.eventLoggingDryRun) {
            System.err.println();
        }
    }

    private void println(String text) {
        if (!this.eventLoggingDryRun) {
            System.err.println(text);
        }
    }
}

