/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.path;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.PathStringBuilder;
import org.opentripplanner.raptor.api.path.TransferPathLeg;
import org.opentripplanner.raptor.api.path.TransitPathLeg;
import org.opentripplanner.raptor.rangeraptor.transit.ForwardTransitCalculator;
import org.opentripplanner.raptor.rangeraptor.transit.TransitCalculator;
import org.opentripplanner.raptor.spi.BoardAndAlightTime;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.raptor.spi.RaptorSlackProvider;

public class PathBuilderLeg<T extends RaptorTripSchedule> {
    private static final int NOT_SET = -999999999;
    private static final TransitCalculator<?> TRANSIT_CALCULATOR = new ForwardTransitCalculator();
    private MyLeg leg;
    private int fromTime = -999999999;
    private int toTime = -999999999;
    private PathBuilderLeg<T> prev = null;
    private PathBuilderLeg<T> next = null;

    private PathBuilderLeg(PathBuilderLeg<T> other) {
        this.fromTime = other.fromTime;
        this.toTime = other.toTime;
        this.leg = other.leg;
        if (other.next != null) {
            this.next = new PathBuilderLeg<T>(other.next);
            this.next.prev = this;
        }
    }

    private PathBuilderLeg(MyLeg leg) {
        this.leg = leg;
        if (leg.isTransit()) {
            MyTransitLeg transit = (MyTransitLeg)leg;
            this.fromTime = transit.fromTime();
            this.toTime = transit.toTime();
        }
    }

    public int fromTime() {
        return this.fromTime;
    }

    public int fromStop() {
        return this.prev.toStop();
    }

    public int fromStopPos() {
        return this.asTransitLeg().fromStopPos();
    }

    public int toTime() {
        return this.toTime;
    }

    public int toStop() {
        return this.leg.toStop();
    }

    public int toStopPos() {
        return this.asTransitLeg().toStopPos();
    }

    public int durationInSec() {
        return this.toTime - this.fromTime;
    }

    @Nullable
    public RaptorConstrainedTransfer constrainedTransferAfterLeg() {
        return this.isTransit() ? this.asTransitLeg().constrainedTransferAfterLeg : null;
    }

    public void setConstrainedTransferAfterLeg(@Nullable RaptorConstrainedTransfer constrainedTransferAfterLeg) {
        MyTransitLeg<T> old = this.asTransitLeg();
        this.leg = new MyTransitLeg(old.trip, old.boardAndAlightTime, constrainedTransferAfterLeg);
    }

    public boolean isAccess() {
        return this.leg.isAccess();
    }

    public boolean hasRides() {
        return this.leg.hasRides();
    }

    public boolean hasNoRides() {
        return !this.hasRides();
    }

    public boolean isTransit() {
        return this.leg.isTransit();
    }

    public boolean isTransfer() {
        return this.leg.isTransfer();
    }

    public boolean isEgress() {
        return this.leg.isEgress();
    }

    public T trip() {
        return this.asTransitLeg().trip;
    }

    public PathBuilderLeg<T> next() {
        return this.next;
    }

    @Nullable
    public PathBuilderLeg<T> nextTransitLeg() {
        return this.next(PathBuilderLeg::isTransit);
    }

    public String toString() {
        return this.leg.toString();
    }

    public void toString(PathStringBuilder builder) {
        this.leg.addToString(builder);
    }

    public void timeShiftThisAndNextLeg(RaptorSlackProvider slackProvider, int iterationDepartureTime) {
        if (this.isAccess()) {
            this.timeShiftAccessTime(slackProvider, iterationDepartureTime);
        }
        if (this.next != null) {
            if (this.next.isTransfer()) {
                this.next.timeShiftTransferTime(slackProvider);
                if (this.next.next().isEgress()) {
                    this.next.timeShiftThisAndNextLeg(slackProvider, iterationDepartureTime);
                }
            } else if (this.next.isEgress()) {
                this.next.timeShiftEgressTime(slackProvider);
            }
        }
    }

    public int generalizedCost(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        if (costCalculator == null) {
            return 0;
        }
        if (this.isAccess()) {
            return this.asAccessLeg().streetPath.generalizedCost();
        }
        if (this.isTransfer()) {
            return this.asTransferLeg().transfer.generalizedCost();
        }
        if (this.isTransit()) {
            return this.transitCost(costCalculator, slackProvider);
        }
        if (this.isEgress()) {
            return this.egressCost(costCalculator, slackProvider);
        }
        throw new IllegalStateException("Unknown leg type: " + this);
    }

    public void changeBoardingPosition(int stopPosition) {
        if (stopPosition == this.fromStopPos()) {
            return;
        }
        MyTransitLeg<T> old = this.asTransitLeg();
        BoardAndAlightTime boardAndAlightTime = new BoardAndAlightTime((RaptorTripSchedule)old.trip, stopPosition, old.boardAndAlightTime.alightStopPos());
        this.leg = new MyTransitLeg(old.trip, boardAndAlightTime, old.constrainedTransferAfterLeg);
        this.fromTime = boardAndAlightTime.boardTime();
    }

    public int waitTimeBeforeNextTransitIncludingSlack() {
        if (this.next.hasRides()) {
            return this.waitTimeBeforeNextLegIncludingSlack();
        }
        return this.waitTimeBeforeNextLegIncludingSlack() + this.next.waitTimeBeforeNextLegIncludingSlack();
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> accessLeg(RaptorAccessEgress access) {
        return new PathBuilderLeg<T>(new MyAccessLeg(access));
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> transferLeg(RaptorTransfer transfer, int toStop) {
        return new PathBuilderLeg<T>(new MyTransferLeg(transfer, toStop));
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> transitLeg(T trip, BoardAndAlightTime boardAndAlightTime) {
        return PathBuilderLeg.transitLeg(trip, boardAndAlightTime, null);
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> transitLeg(T trip, BoardAndAlightTime boardAndAlightTime, @Nullable RaptorConstrainedTransfer txConstrainedAfterLeg) {
        return new PathBuilderLeg<T>(new MyTransitLeg<T>(trip, boardAndAlightTime, txConstrainedAfterLeg));
    }

    static <T extends RaptorTripSchedule> PathBuilderLeg<T> egress(RaptorAccessEgress egress) {
        return new PathBuilderLeg<T>(new MyEgressLeg(egress));
    }

    PathBuilderLeg<T> prev() {
        return this.prev;
    }

    void setPrev(PathBuilderLeg<T> prev) {
        this.prev = prev;
    }

    void setNext(PathBuilderLeg<T> next) {
        this.next = next;
    }

    @Nullable
    PathBuilderLeg<T> prevTransitLeg() {
        PathBuilderLeg<T> it = this.prev();
        if (it == null) {
            return null;
        }
        if (it.isTransfer()) {
            it = it.prev();
        }
        if (it == null) {
            return null;
        }
        return it.isTransit() ? it : null;
    }

    @Nullable
    PathBuilderLeg<T> next(Predicate<PathBuilderLeg<T>> test) {
        PathBuilderLeg<T> it;
        for (it = this.next(); it != null && !test.test(it); it = it.next()) {
        }
        return it;
    }

    PathBuilderLeg<T> mutate() {
        return new PathBuilderLeg<T>(this);
    }

    AccessPathLeg<T> createAccessPathLeg(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        PathLeg<T> nextLeg = this.next.createPathLeg(costCalculator, slackProvider);
        RaptorAccessEgress accessPath = this.asAccessLeg().streetPath;
        int cost = PathBuilderLeg.cost(costCalculator, accessPath);
        return new AccessPathLeg<T>(accessPath, this.fromTime, this.toTime, cost, nextLeg);
    }

    private static int cost(RaptorCostCalculator<?> costCalculator, RaptorAccessEgress streetPath) {
        return costCalculator != null ? streetPath.generalizedCost() : 0;
    }

    private static int cost(RaptorCostCalculator<?> costCalculator, RaptorTransfer transfer) {
        return costCalculator != null ? transfer.generalizedCost() : 0;
    }

    private void setTime(int fromTime, int toTime) {
        this.fromTime = fromTime;
        this.toTime = toTime;
    }

    private boolean isAccessWithoutRides() {
        return this.isAccess() && this.hasNoRides();
    }

    private MyAccessLeg asAccessLeg() {
        return (MyAccessLeg)this.leg;
    }

    private MyTransferLeg asTransferLeg() {
        return (MyTransferLeg)this.leg;
    }

    private MyTransitLeg<T> asTransitLeg() {
        return (MyTransitLeg)this.leg;
    }

    private MyEgressLeg asEgressLeg() {
        return (MyEgressLeg)this.leg;
    }

    private PathLeg<T> createPathLeg(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        if (this.isAccess()) {
            return this.createAccessPathLeg(costCalculator, slackProvider);
        }
        if (this.isTransit()) {
            return this.createTransitPathLeg(costCalculator, slackProvider);
        }
        if (this.isTransfer()) {
            return this.createTransferPathLeg(costCalculator, slackProvider);
        }
        if (this.isEgress()) {
            return this.createEgressPathLeg(costCalculator, slackProvider);
        }
        throw new IllegalStateException("Unknown leg type: " + this);
    }

    private TransferPathLeg<T> createTransferPathLeg(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        PathLeg<T> nextLeg = this.next.createPathLeg(costCalculator, slackProvider);
        RaptorTransfer transfer = this.asTransferLeg().transfer;
        int cost = PathBuilderLeg.cost(costCalculator, transfer);
        return new TransferPathLeg<T>(this.fromStop(), this.fromTime, this.toTime, cost, transfer, nextLeg);
    }

    private TransitPathLeg<T> createTransitPathLeg(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        PathLeg<T> nextLeg = this.next.createPathLeg(costCalculator, slackProvider);
        MyTransitLeg<T> leg = this.asTransitLeg();
        int cost = this.transitCost(costCalculator, slackProvider);
        return new TransitPathLeg(leg.trip, leg.boardAndAlightTime.boardTime(), leg.boardAndAlightTime.alightTime(), leg.boardAndAlightTime.boardStopPos(), leg.boardAndAlightTime.alightStopPos(), leg.constrainedTransferAfterLeg, cost, nextLeg);
    }

    private EgressPathLeg<T> createEgressPathLeg(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        int cost = this.egressCost(costCalculator, slackProvider);
        return new EgressPathLeg(this.asEgressLeg().streetPath, this.fromTime, this.toTime, cost);
    }

    private int stopArrivalTime(RaptorSlackProvider slackProvider) {
        if (!this.isTransit()) {
            return this.toTime;
        }
        return this.toTime + slackProvider.alightSlack(this.asTransitLeg().trip.pattern().slackIndex());
    }

    private int waitTimeAfterPrevStopArrival(RaptorSlackProvider slackProvider) {
        return this.fromTime - this.prev.stopArrivalTime(slackProvider);
    }

    private int waitTimeBeforeNextLegIncludingSlack() {
        return this.next.fromTime - this.toTime;
    }

    private int transitStopArrivalTimeBefore(RaptorSlackProvider slackProvider, boolean withTransferSlack) {
        MyTransitLeg<T> leg = this.asTransitLeg();
        int slack = slackProvider.boardSlack(leg.trip.pattern().slackIndex()) + (withTransferSlack ? slackProvider.transferSlack() : 0);
        return leg.fromTime() - slack;
    }

    private void timeShiftAccessTime(RaptorSlackProvider slackProvider, int iterationDepartureTime) {
        RaptorAccessEgress accessPath = this.asAccessLeg().streetPath;
        PathBuilderLeg<T> nextTransitLeg = this.nextTransitLeg();
        if (nextTransitLeg == null) {
            int fromTime = accessPath.earliestDepartureTime(iterationDepartureTime);
            PathBuilderLeg.assertTimeExist(fromTime, accessPath, "Access can not be time-shifted after iteration-departure-time.");
            this.setTime(fromTime, fromTime + accessPath.durationInSeconds());
        } else {
            int toTime = nextTransitLeg.transitStopArrivalTimeBefore(slackProvider, this.hasRides());
            if (this.next.isTransfer()) {
                toTime -= this.next.asTransferLeg().transfer.durationInSeconds();
            }
            toTime = accessPath.latestArrivalTime(toTime);
            PathBuilderLeg.assertTimeExist(toTime, accessPath, "Access can not be time-shifted before first transit leg.");
            this.setTime(toTime - accessPath.durationInSeconds(), toTime);
        }
    }

    private void timeShiftTransferTime(RaptorSlackProvider slackProvider) {
        int newFromTime;
        if (this.prev.isTransit()) {
            newFromTime = this.prev.toTime() + slackProvider.alightSlack(this.prev.asTransitLeg().trip.pattern().slackIndex());
        } else if (this.prev.isAccess()) {
            newFromTime = this.prev.toTime();
        } else {
            throw new IllegalStateException("Unexpected leg type before TransferLeg: " + this);
        }
        this.setTime(newFromTime, newFromTime + this.asTransferLeg().transfer.durationInSeconds());
    }

    private void timeShiftEgressTime(RaptorSlackProvider slackProvider) {
        RaptorAccessEgress egressPath = this.asEgressLeg().streetPath;
        int stopArrivalTime = this.prev.stopArrivalTime(slackProvider);
        int egressDepartureTime = TRANSIT_CALCULATOR.calculateEgressDepartureTime(stopArrivalTime, egressPath, slackProvider.transferSlack());
        PathBuilderLeg.assertTimeExist(egressDepartureTime, egressPath, "Transit does not arrive in time to board flex access.");
        this.setTime(egressDepartureTime, egressDepartureTime + egressPath.durationInSeconds());
    }

    private int transitCost(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        if (costCalculator == null) {
            return 0;
        }
        MyTransitLeg<T> leg = this.asTransitLeg();
        int prevStopArrivalTime = this.prev == null ? this.fromTime : this.prev.stopArrivalTime(slackProvider);
        PathBuilderLeg<T> prevTransit = this.prevTransitLeg();
        RaptorConstrainedTransfer txBeforeLeg = prevTransit == null ? null : prevTransit.constrainedTransferAfterLeg();
        RaptorTransferConstraint transferConstraint = txBeforeLeg == null ? RaptorTransferConstraint.REGULAR_TRANSFER : txBeforeLeg.getTransferConstraint();
        boolean firstBoarding = this.prev != null && this.prev.isAccessWithoutRides();
        int boardCost = costCalculator.boardingCost(firstBoarding, prevStopArrivalTime, leg.fromStop(), this.fromTime, this.trip(), transferConstraint);
        return costCalculator.transitArrivalCost(boardCost, slackProvider.alightSlack(leg.trip.pattern().slackIndex()), this.durationInSec(), leg.trip, this.toStop());
    }

    private int egressCost(RaptorCostCalculator<T> costCalculator, RaptorSlackProvider slackProvider) {
        if (costCalculator == null) {
            return 0;
        }
        RaptorAccessEgress egressPath = this.asEgressLeg().streetPath;
        int egressCost = costCalculator.costEgress(egressPath);
        if (this.prev == null) {
            return egressCost;
        }
        int waitCost = costCalculator.waitCost(this.waitTimeAfterPrevStopArrival(slackProvider));
        return waitCost + egressCost;
    }

    private static IllegalStateException egressDepartureNotAvailable(int arrivalTime, RaptorAccessEgress egressPath) {
        return new IllegalStateException("Unable to reconstruct path. Transit does not arrive in time to board flex access. Arrived: " + TimeUtils.timeToStrCompact(arrivalTime) + " Egress: " + egressPath);
    }

    private static int assertTimeExist(int time, RaptorAccessEgress path, String details) {
        if (time == -1999000000) {
            throw new IllegalStateException(String.format("Unable to reconstruct path. %s. Arrival-time stop: %s, path: %s", details, TimeUtils.timeToStrCompact(time), path));
        }
        return time;
    }

    private static interface MyLeg {
        default public boolean isAccess() {
            return false;
        }

        default public boolean isTransit() {
            return false;
        }

        default public boolean isTransfer() {
            return false;
        }

        default public boolean isEgress() {
            return false;
        }

        public boolean hasRides();

        public int toStop();

        public PathStringBuilder addToString(PathStringBuilder var1);
    }

    private static class MyTransitLeg<T extends RaptorTripSchedule>
    extends AbstractMyLeg {
        final T trip;
        final BoardAndAlightTime boardAndAlightTime;
        @Nullable
        private final RaptorConstrainedTransfer constrainedTransferAfterLeg;

        private MyTransitLeg(T trip, BoardAndAlightTime boardAndAlightTime, RaptorConstrainedTransfer constrainedTransferAfterLeg) {
            this.trip = trip;
            this.boardAndAlightTime = boardAndAlightTime;
            this.constrainedTransferAfterLeg = constrainedTransferAfterLeg;
        }

        @Override
        public boolean isTransit() {
            return true;
        }

        @Override
        public boolean hasRides() {
            return true;
        }

        @Override
        public int toStop() {
            return this.trip.pattern().stopIndex(this.boardAndAlightTime.alightStopPos());
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.transit(this.trip.pattern().debugInfo(), this.fromTime(), this.toTime()).stop(this.toStop());
        }

        public int fromStop() {
            return this.trip.pattern().stopIndex(this.boardAndAlightTime.boardStopPos());
        }

        public int fromStopPos() {
            return this.boardAndAlightTime.boardStopPos();
        }

        public int fromTime() {
            return this.boardAndAlightTime.boardTime();
        }

        public int toStopPos() {
            return this.boardAndAlightTime.alightStopPos();
        }

        public int toTime() {
            return this.boardAndAlightTime.alightTime();
        }
    }

    private static class MyAccessLeg
    extends MyStreetLeg {
        private MyAccessLeg(RaptorAccessEgress streetPath) {
            super(streetPath);
        }

        @Override
        public boolean isAccess() {
            return true;
        }

        @Override
        public int toStop() {
            return this.streetPath.stop();
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.accessEgress(this.streetPath).stop(this.toStop());
        }
    }

    private static class MyTransferLeg
    extends AbstractMyLeg {
        final int toStop;
        final RaptorTransfer transfer;

        MyTransferLeg(RaptorTransfer transfer, int toStop) {
            this.transfer = transfer;
            this.toStop = toStop;
        }

        @Override
        public boolean isTransfer() {
            return true;
        }

        @Override
        public boolean hasRides() {
            return false;
        }

        @Override
        public int toStop() {
            return this.toStop;
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.walk(this.transfer.durationInSeconds()).stop(this.toStop());
        }
    }

    private static class MyEgressLeg
    extends MyStreetLeg {
        MyEgressLeg(RaptorAccessEgress streetPath) {
            super(streetPath);
        }

        @Override
        public boolean isEgress() {
            return true;
        }

        @Override
        public int toStop() {
            throw new IllegalStateException("Egress leg have no toStop");
        }

        @Override
        public PathStringBuilder addToString(PathStringBuilder builder) {
            return builder.accessEgress(this.streetPath);
        }
    }

    private static abstract class MyStreetLeg
    extends AbstractMyLeg {
        final RaptorAccessEgress streetPath;

        MyStreetLeg(RaptorAccessEgress streetPath) {
            this.streetPath = streetPath;
        }

        @Override
        public boolean hasRides() {
            return this.streetPath.hasRides();
        }
    }

    private static abstract class AbstractMyLeg
    implements MyLeg {
        private AbstractMyLeg() {
        }

        public final String toString() {
            return this.addToString(new PathStringBuilder(null)).toString();
        }
    }
}

