/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.configure;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.RaptorTuningParameters;
import org.opentripplanner.raptor.rangeraptor.DefaultRangeRaptorWorker;
import org.opentripplanner.raptor.rangeraptor.context.SearchContext;
import org.opentripplanner.raptor.rangeraptor.internalapi.Heuristics;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorker;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerState;
import org.opentripplanner.raptor.rangeraptor.internalapi.RoutingStrategy;
import org.opentripplanner.raptor.rangeraptor.multicriteria.configure.McRangeRaptorConfig;
import org.opentripplanner.raptor.rangeraptor.standard.configure.StdRangeRaptorConfig;
import org.opentripplanner.raptor.rangeraptor.transit.RaptorSearchWindowCalculator;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;

public class RaptorConfig<T extends RaptorTripSchedule> {
    private final ExecutorService threadPool;
    private final RaptorTuningParameters tuningParameters;

    public RaptorConfig(RaptorTuningParameters tuningParameters) {
        this.tuningParameters = tuningParameters;
        this.threadPool = this.createNewThreadPool(tuningParameters.searchThreadPoolSize());
    }

    public static <T extends RaptorTripSchedule> RaptorConfig<T> defaultConfigForTest() {
        return new RaptorConfig<T>(new RaptorTuningParameters(){});
    }

    public SearchContext<T> context(RaptorTransitDataProvider<T> transit, RaptorRequest<T> request) {
        return new SearchContext<T>(request, this.tuningParameters, transit);
    }

    public RaptorWorker<T> createStdWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        SearchContext<T> context = this.context(transitData, request);
        StdRangeRaptorConfig<T> stdConfig = new StdRangeRaptorConfig<T>(context);
        return this.createWorker(context, stdConfig.state(), stdConfig.strategy());
    }

    public RaptorWorker<T> createMcWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request, Heuristics heuristics) {
        SearchContext<T> context = this.context(transitData, request);
        return new McRangeRaptorConfig(context).createWorker(heuristics, (state, routingStrategy) -> this.createWorker(context, (RaptorWorkerState<T>)state, (RoutingStrategy<T>)routingStrategy));
    }

    public RaptorWorker<T> createHeuristicSearch(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        SearchContext<T> context = this.context(transitData, request);
        StdRangeRaptorConfig<T> stdConfig = new StdRangeRaptorConfig<T>(context);
        return this.createWorker(context, stdConfig.state(), stdConfig.strategy());
    }

    public Heuristics createHeuristic(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request, RaptorWorkerResult<T> results) {
        SearchContext<T> context = this.context(transitData, request);
        return new StdRangeRaptorConfig<T>(context).createHeuristics(results);
    }

    public boolean isMultiThreaded() {
        return this.threadPool != null;
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public void shutdown() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public RaptorSearchWindowCalculator searchWindowCalculator() {
        return new RaptorSearchWindowCalculator(this.tuningParameters.dynamicSearchWindowCoefficients());
    }

    private RaptorWorker<T> createWorker(SearchContext<T> ctx, RaptorWorkerState<T> workerState, RoutingStrategy<T> routingStrategy) {
        return new DefaultRangeRaptorWorker<T>(workerState, routingStrategy, ctx.transit(), ctx.slackProvider(), ctx.accessPaths(), ctx.roundProvider(), ctx.calculator(), ctx.createLifeCyclePublisher(), ctx.performanceTimers(), ctx.useConstrainedTransfers());
    }

    @Nullable
    private ExecutorService createNewThreadPool(int size) {
        return size > 0 ? Executors.newFixedThreadPool(size) : null;
    }
}

