/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.view;

import javax.annotation.Nullable;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.PathLegType;
import org.opentripplanner.raptor.api.model.RaptorTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.TransitArrival;
import org.opentripplanner.raptor.api.view.AccessPathView;
import org.opentripplanner.raptor.api.view.EgressPathView;
import org.opentripplanner.raptor.api.view.TransitPathView;

public interface ArrivalView<T extends RaptorTripSchedule> {
    public int stop();

    public int round();

    default public int numberOfTransfers() {
        return this.round() - 1;
    }

    default public boolean isFirstRound() {
        return this.round() == 0;
    }

    public int arrivalTime();

    public int c1();

    public int c2();

    @Nullable
    public ArrivalView<T> previous();

    @Nullable
    default public TransitArrival<T> mostRecentTransitArrival() {
        return null;
    }

    public PathLegType arrivedBy();

    default public boolean arrivedBy(PathLegType expected) {
        return this.arrivedBy().is(expected);
    }

    default public AccessPathView accessPath() {
        throw new UnsupportedOperationException();
    }

    default public TransitPathView<T> transitPath() {
        throw new UnsupportedOperationException();
    }

    default public RaptorTransfer transfer() {
        throw new UnsupportedOperationException();
    }

    default public boolean arrivedAtDestination() {
        return false;
    }

    default public EgressPathView egressPath() {
        throw new UnsupportedOperationException();
    }

    public boolean arrivedOnBoard();

    default public String asString() {
        String arrival = "[" + TimeUtils.timeToStrCompact(this.arrivalTime()) + " " + OtpNumberFormat.formatCostCenti(this.c1()) + "]";
        return switch (this.arrivedBy()) {
            default -> throw new IncompatibleClassChangeError();
            case PathLegType.ACCESS -> String.format("Access { stop: %d, arrival: %s, path: %s }", this.stop(), arrival, this.accessPath().access());
            case PathLegType.TRANSIT -> String.format("Transit { round: %d, stop: %d, arrival: %s, pattern: %s }", this.round(), this.stop(), arrival, this.transitPath().trip().pattern().debugInfo());
            case PathLegType.TRANSFER -> String.format("Walk { round: %d, stop: %d, arrival: %s, path: %s }", this.round(), this.stop(), arrival, this.transfer());
            case PathLegType.EGRESS -> String.format("Egress { round: %d, from-stop: %d, arrival: %s, path: %s }", this.round(), this.egressPath().egress().stop(), arrival, this.egressPath().egress());
        };
    }
}

