/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.response;

import java.util.Collection;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.response.StopArrivals;

public class RaptorResponse<T extends RaptorTripSchedule> {
    private final Collection<RaptorPath<T>> paths;
    private final RaptorRequest<T> requestOriginal;
    private final RaptorRequest<T> requestUsed;
    private final StopArrivals arrivals;

    public RaptorResponse(Collection<RaptorPath<T>> paths, StopArrivals arrivals, RaptorRequest<T> requestOriginal, RaptorRequest<T> requestUsed) {
        this.paths = paths;
        this.arrivals = arrivals;
        this.requestOriginal = requestOriginal;
        this.requestUsed = requestUsed;
    }

    public Collection<RaptorPath<T>> paths() {
        return this.paths;
    }

    public boolean containsUnknownPaths() {
        return this.paths.stream().anyMatch(RaptorPath::isUnknownPath);
    }

    public StopArrivals getArrivals() {
        return this.arrivals;
    }

    public RaptorRequest<T> requestOriginal() {
        return this.requestOriginal;
    }

    public RaptorRequest<T> requestUsed() {
        return this.requestUsed;
    }

    public String toString() {
        return ToStringBuilder.of(RaptorResponse.class).addObj("paths", this.paths).addObj("requestOriginal", this.requestOriginal).addObj("requestUsed", this.requestUsed).toString();
    }
}

