/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.raptor.api.request.SearchParams;

public class SearchParamsBuilder<T extends RaptorTripSchedule> {
    private final RaptorRequestBuilder<T> parent;
    private final Collection<RaptorAccessEgress> accessPaths = new ArrayList<RaptorAccessEgress>();
    private final Collection<RaptorAccessEgress> egressPaths = new ArrayList<RaptorAccessEgress>();
    private int earliestDepartureTime;
    private int latestArrivalTime;
    private int searchWindowInSeconds;
    private boolean preferLateArrival;
    private int numberOfAdditionalTransfers;
    private int maxNumberOfTransfers;
    private boolean timetable;
    private boolean constrainedTransfers;
    private boolean allowEmptyAccessEgressPaths;

    public SearchParamsBuilder(RaptorRequestBuilder<T> parent, SearchParams defaults) {
        this.parent = parent;
        this.earliestDepartureTime = defaults.earliestDepartureTime();
        this.latestArrivalTime = defaults.latestArrivalTime();
        this.searchWindowInSeconds = defaults.searchWindowInSeconds();
        this.preferLateArrival = defaults.preferLateArrival();
        this.numberOfAdditionalTransfers = defaults.numberOfAdditionalTransfers();
        this.maxNumberOfTransfers = defaults.maxNumberOfTransfers();
        this.timetable = defaults.timetable();
        this.constrainedTransfers = defaults.constrainedTransfers();
        this.accessPaths.addAll(defaults.accessPaths());
        this.egressPaths.addAll(defaults.egressPaths());
        this.allowEmptyAccessEgressPaths = defaults.allowEmptyAccessEgressPaths();
    }

    public int earliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public SearchParamsBuilder<T> earliestDepartureTime(int earliestDepartureTime) {
        this.earliestDepartureTime = earliestDepartureTime;
        return this;
    }

    public int latestArrivalTime() {
        return this.latestArrivalTime;
    }

    public SearchParamsBuilder<T> latestArrivalTime(int latestArrivalTime) {
        this.latestArrivalTime = latestArrivalTime;
        return this;
    }

    public int searchWindowInSeconds() {
        return this.searchWindowInSeconds;
    }

    public SearchParamsBuilder<T> searchWindowInSeconds(int searchWindowInSeconds) {
        this.searchWindowInSeconds = searchWindowInSeconds;
        return this;
    }

    public SearchParamsBuilder<T> searchWindow(Duration searchWindow) {
        this.searchWindowInSeconds = searchWindow == null ? -1999000000 : (int)searchWindow.toSeconds();
        return this;
    }

    public SearchParamsBuilder<T> searchOneIterationOnly() {
        return this.searchWindowInSeconds(0);
    }

    public boolean preferLateArrival() {
        return this.preferLateArrival;
    }

    public SearchParamsBuilder<T> preferLateArrival(boolean enable) {
        this.preferLateArrival = enable;
        return this;
    }

    public int numberOfAdditionalTransfers() {
        return this.numberOfAdditionalTransfers;
    }

    public SearchParamsBuilder<T> numberOfAdditionalTransfers(int numberOfAdditionalTransfers) {
        this.numberOfAdditionalTransfers = numberOfAdditionalTransfers;
        return this;
    }

    public int maxNumberOfTransfers() {
        return this.maxNumberOfTransfers;
    }

    public SearchParamsBuilder<T> maxNumberOfTransfers(int maxNumberOfTransfers) {
        this.maxNumberOfTransfers = maxNumberOfTransfers;
        return this;
    }

    public boolean timetable() {
        return this.timetable;
    }

    public SearchParamsBuilder<T> timetable(boolean enable) {
        this.timetable = enable;
        return this;
    }

    public boolean constrainedTransfers() {
        return this.constrainedTransfers;
    }

    public SearchParamsBuilder<T> constrainedTransfers(boolean enable) {
        this.constrainedTransfers = enable;
        return this;
    }

    public Collection<RaptorAccessEgress> accessPaths() {
        return this.accessPaths;
    }

    public SearchParamsBuilder<T> addAccessPaths(Collection<? extends RaptorAccessEgress> accessPaths) {
        this.accessPaths.addAll(accessPaths);
        return this;
    }

    public SearchParamsBuilder<T> addAccessPaths(RaptorAccessEgress ... accessPaths) {
        return this.addAccessPaths(Arrays.asList(accessPaths));
    }

    public Collection<RaptorAccessEgress> egressPaths() {
        return this.egressPaths;
    }

    public SearchParamsBuilder<T> addEgressPaths(Collection<? extends RaptorAccessEgress> egressPaths) {
        this.egressPaths.addAll(egressPaths);
        return this;
    }

    public SearchParamsBuilder<T> addEgressPaths(RaptorAccessEgress ... egressPaths) {
        return this.addEgressPaths(Arrays.asList(egressPaths));
    }

    public SearchParamsBuilder<T> allowEmptyAccessEgressPaths(boolean allowEmptyEgressPaths) {
        this.allowEmptyAccessEgressPaths = allowEmptyEgressPaths;
        return this;
    }

    public boolean allowEmptyAccessEgressPaths() {
        return this.allowEmptyAccessEgressPaths;
    }

    public RaptorRequest<T> build() {
        return this.parent.build();
    }

    public SearchParams buildSearchParam() {
        return new SearchParams(this);
    }

    public String toString() {
        return ToStringBuilder.of(SearchParams.class).addServiceTime("earliestDepartureTime", this.earliestDepartureTime, -1999000000).addServiceTime("latestArrivalTime", this.latestArrivalTime, -1999000000).addDurationSec("searchWindow", this.searchWindowInSeconds).addBoolIfTrue("departAsLateAsPossible", this.preferLateArrival).addNum("numberOfAdditionalTransfers", this.numberOfAdditionalTransfers).addCollection("accessPaths", this.accessPaths, 5).addCollection("egressPaths", this.egressPaths, 5).toString();
    }
}

