/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.SearchParamsBuilder;

public class SearchParams {
    private final int earliestDepartureTime;
    private final int latestArrivalTime;
    private final int searchWindowInSeconds;
    private final boolean preferLateArrival;
    private final int numberOfAdditionalTransfers;
    private final int maxNumberOfTransfers;
    private final boolean timetable;
    private final boolean constrainedTransfers;
    private final Collection<RaptorAccessEgress> accessPaths;
    private final Collection<RaptorAccessEgress> egressPaths;
    private final boolean allowEmptyAccessEgressPaths;

    private SearchParams() {
        this.earliestDepartureTime = -1999000000;
        this.latestArrivalTime = -1999000000;
        this.searchWindowInSeconds = -1999000000;
        this.preferLateArrival = false;
        this.numberOfAdditionalTransfers = 5;
        this.maxNumberOfTransfers = -1999000000;
        this.timetable = false;
        this.constrainedTransfers = false;
        this.accessPaths = List.of();
        this.egressPaths = List.of();
        this.allowEmptyAccessEgressPaths = false;
    }

    SearchParams(SearchParamsBuilder<?> builder) {
        this.earliestDepartureTime = builder.earliestDepartureTime();
        this.latestArrivalTime = builder.latestArrivalTime();
        this.searchWindowInSeconds = builder.searchWindowInSeconds();
        this.preferLateArrival = builder.preferLateArrival();
        this.numberOfAdditionalTransfers = builder.numberOfAdditionalTransfers();
        this.maxNumberOfTransfers = builder.maxNumberOfTransfers();
        this.timetable = builder.timetable();
        this.constrainedTransfers = builder.constrainedTransfers();
        this.accessPaths = List.copyOf(builder.accessPaths());
        this.egressPaths = List.copyOf(builder.egressPaths());
        this.allowEmptyAccessEgressPaths = builder.allowEmptyAccessEgressPaths();
    }

    public int earliestDepartureTime() {
        return this.earliestDepartureTime;
    }

    public boolean isEarliestDepartureTimeSet() {
        return this.earliestDepartureTime != -1999000000;
    }

    public int latestArrivalTime() {
        return this.latestArrivalTime;
    }

    public boolean isLatestArrivalTimeSet() {
        return this.latestArrivalTime != -1999000000;
    }

    public int searchWindowInSeconds() {
        return this.searchWindowInSeconds;
    }

    public boolean isSearchWindowSet() {
        return this.searchWindowInSeconds != -1999000000;
    }

    public boolean searchOneIterationOnly() {
        return this.searchWindowInSeconds == 0;
    }

    public boolean preferLateArrival() {
        return this.preferLateArrival;
    }

    public int numberOfAdditionalTransfers() {
        return this.numberOfAdditionalTransfers;
    }

    public int maxNumberOfTransfers() {
        return this.maxNumberOfTransfers;
    }

    public boolean isMaxNumberOfTransfersSet() {
        return this.maxNumberOfTransfers != -1999000000;
    }

    public boolean timetable() {
        return this.timetable;
    }

    public boolean constrainedTransfers() {
        return this.constrainedTransfers;
    }

    public Collection<RaptorAccessEgress> accessPaths() {
        return this.accessPaths;
    }

    public Collection<RaptorAccessEgress> egressPaths() {
        return this.egressPaths;
    }

    public boolean allowEmptyAccessEgressPaths() {
        return this.allowEmptyAccessEgressPaths;
    }

    public int accessEgressMaxDurationSeconds() {
        return Math.max(this.accessPaths.stream().mapToInt(RaptorAccessEgress::durationInSeconds).max().orElse(0), this.egressPaths.stream().mapToInt(RaptorAccessEgress::durationInSeconds).max().orElse(0));
    }

    public int hashCode() {
        return Objects.hash(this.earliestDepartureTime, this.latestArrivalTime, this.searchWindowInSeconds, this.preferLateArrival, this.numberOfAdditionalTransfers, this.accessPaths, this.egressPaths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchParams that = (SearchParams)o;
        return this.earliestDepartureTime == that.earliestDepartureTime && this.latestArrivalTime == that.latestArrivalTime && this.searchWindowInSeconds == that.searchWindowInSeconds && this.preferLateArrival == that.preferLateArrival && this.numberOfAdditionalTransfers == that.numberOfAdditionalTransfers && this.accessPaths.equals(that.accessPaths) && this.egressPaths.equals(that.egressPaths);
    }

    public String toString() {
        return ToStringBuilder.of(SearchParams.class).addServiceTime("earliestDepartureTime", this.earliestDepartureTime, -1999000000).addServiceTime("latestArrivalTime", this.latestArrivalTime, -1999000000).addDurationSec("searchWindow", this.searchWindowInSeconds).addBoolIfTrue("departAsLateAsPossible", this.preferLateArrival).addNum("numberOfAdditionalTransfers", this.numberOfAdditionalTransfers).addCollection("accessPaths", this.accessPaths, 5).addCollection("egressPaths", this.egressPaths, 5).toString();
    }

    static SearchParams defaults() {
        return new SearchParams();
    }

    void verify() {
        RaptorRequest.assertProperty(this.isEarliestDepartureTimeSet() || this.isLatestArrivalTimeSet(), "'earliestDepartureTime' or 'latestArrivalTime' is required.");
        RaptorRequest.assertProperty(this.allowEmptyAccessEgressPaths || !this.accessPaths.isEmpty(), "At least one 'accessPath' is required.");
        RaptorRequest.assertProperty(this.allowEmptyAccessEgressPaths || !this.egressPaths.isEmpty(), "At least one 'egressPath' is required.");
        RaptorRequest.assertProperty(!this.preferLateArrival || this.isLatestArrivalTimeSet(), "The 'latestArrivalTime' is required when 'departAsLateAsPossible' is set.");
        RaptorRequest.assertProperty(!this.preferLateArrival || !this.timetable, "The 'departAsLateAsPossible' is not allowed together with 'timetableEnabled'.");
    }
}

