/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import org.opentripplanner.raptor.api.debug.RaptorTimers;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.raptor.api.request.MultiCriteriaRequest;
import org.opentripplanner.raptor.api.request.Optimization;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.request.SearchParamsBuilder;

public class RaptorRequestBuilder<T extends RaptorTripSchedule> {
    private final SearchParamsBuilder<T> searchParams;
    private final Set<Optimization> optimizations = EnumSet.noneOf(Optimization.class);
    private final DebugRequestBuilder debug;
    private SearchDirection searchDirection;
    private MultiCriteriaRequest<T> multiCriteria;
    private RaptorTimers performanceTimers;
    private RaptorProfile profile;
    private boolean freezeAliasFields = false;

    public RaptorRequestBuilder() {
        this(RaptorRequest.defaults());
    }

    RaptorRequestBuilder(RaptorRequest<T> defaults) {
        this.searchParams = new SearchParamsBuilder(this, defaults.searchParams());
        this.searchDirection = defaults.searchDirection();
        this.profile = defaults.profile();
        this.optimizations.addAll(defaults.optimizations());
        this.multiCriteria = defaults.multiCriteria();
        this.performanceTimers = defaults.performanceTimers();
        this.debug = new DebugRequestBuilder(defaults.debug());
    }

    public SearchParamsBuilder<T> searchParams() {
        return this.searchParams;
    }

    public RaptorProfile profile() {
        return this.profile;
    }

    public RaptorRequestBuilder<T> profile(RaptorProfile profile) {
        this.verifyAliasNotGeneratedYet();
        this.profile = profile;
        return this;
    }

    public SearchDirection searchDirection() {
        return this.searchDirection;
    }

    public RaptorRequestBuilder<T> searchDirection(SearchDirection searchDirection) {
        this.verifyAliasNotGeneratedYet();
        this.searchDirection = searchDirection;
        return this;
    }

    public Collection<Optimization> optimizations() {
        return this.optimizations;
    }

    public RaptorRequestBuilder<T> enableOptimization(Optimization optimization) {
        this.verifyAliasNotGeneratedYet();
        this.optimizations.add(optimization);
        return this;
    }

    public RaptorRequestBuilder<T> clearOptimizations() {
        this.optimizations.clear();
        return this;
    }

    public RaptorRequestBuilder<T> disableOptimization(Optimization optimization) {
        this.optimizations.remove((Object)optimization);
        return this;
    }

    public MultiCriteriaRequest<T> multiCriteria() {
        return this.multiCriteria;
    }

    public RaptorRequestBuilder<T> withMultiCriteria(Consumer<MultiCriteriaRequest.Builder<T>> body) {
        MultiCriteriaRequest.Builder<T> builder = this.multiCriteria.copyOf();
        body.accept(builder);
        this.multiCriteria = builder.build();
        return this;
    }

    public RaptorTimers performanceTimers() {
        return this.performanceTimers;
    }

    public RaptorRequestBuilder<T> performanceTimers(RaptorTimers performanceTimers) {
        this.performanceTimers = performanceTimers;
        return this;
    }

    public DebugRequestBuilder debug() {
        return this.debug;
    }

    public RaptorRequest<T> build() {
        return new RaptorRequest(this);
    }

    public String generateAlias() {
        this.freezeAliasFields = true;
        return RaptorRequestBuilder.generateRequestAlias(this.profile, this.searchDirection, this.optimizations);
    }

    static String generateRequestAlias(RaptorProfile profile, SearchDirection searchDirection, Collection<Optimization> optimizations) {
        Object name = profile.abbreviation();
        if (searchDirection.isInReverse()) {
            name = (String)name + "-Rev";
        }
        if (Optimization.PARALLEL.isOneOf(optimizations)) {
            name = (String)name + "-LL";
        }
        if (Optimization.PARETO_CHECK_AGAINST_DESTINATION.isOneOf(optimizations)) {
            name = (String)name + "-DP";
        }
        return name;
    }

    private void verifyAliasNotGeneratedYet() {
        if (this.freezeAliasFields) {
            throw new IllegalStateException("The alias is generated before one of the fileds it relay on is set.");
        }
    }
}

