/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.debug.RaptorTimers;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.SearchDirection;
import org.opentripplanner.raptor.api.request.DebugRequest;
import org.opentripplanner.raptor.api.request.MultiCriteriaRequest;
import org.opentripplanner.raptor.api.request.Optimization;
import org.opentripplanner.raptor.api.request.RaptorProfile;
import org.opentripplanner.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.raptor.api.request.SearchParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaptorRequest<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorRequest.class);
    private final String alias;
    private final SearchParams searchParams;
    private final RaptorProfile profile;
    private final SearchDirection searchDirection;
    private final Set<Optimization> optimizations;
    private final MultiCriteriaRequest<T> multiCriteria;
    private final DebugRequest debug;
    private final RaptorTimers performanceTimers;

    private RaptorRequest() {
        this.searchParams = SearchParams.defaults();
        this.profile = RaptorProfile.MULTI_CRITERIA;
        this.searchDirection = SearchDirection.FORWARD;
        this.optimizations = Collections.emptySet();
        this.multiCriteria = MultiCriteriaRequest.of().build();
        this.performanceTimers = RaptorTimers.NOOP;
        this.debug = DebugRequest.defaults();
        this.alias = RaptorRequestBuilder.generateRequestAlias(this.profile, this.searchDirection, this.optimizations);
    }

    RaptorRequest(RaptorRequestBuilder<T> builder) {
        this.alias = builder.generateAlias();
        this.searchParams = builder.searchParams().buildSearchParam();
        this.profile = builder.profile();
        this.searchDirection = builder.searchDirection();
        this.optimizations = Set.copyOf(builder.optimizations());
        this.multiCriteria = builder.multiCriteria();
        this.performanceTimers = builder.performanceTimers();
        this.debug = builder.debug().build();
        this.verify();
    }

    public RaptorRequestBuilder<T> mutate() {
        return new RaptorRequestBuilder(this);
    }

    public String alias() {
        return this.alias;
    }

    public SearchParams searchParams() {
        return this.searchParams;
    }

    public boolean useConstrainedTransfers() {
        return this.profile.supportsConstrainedTransfers() && this.searchParams.constrainedTransfers();
    }

    public boolean isDynamicSearch() {
        if (this.profile().is(RaptorProfile.MULTI_CRITERIA)) {
            return true;
        }
        if (this.profile.is(RaptorProfile.STANDARD)) {
            return !this.searchParams().searchOneIterationOnly();
        }
        return false;
    }

    public RaptorProfile profile() {
        return this.profile;
    }

    public SearchDirection searchDirection() {
        return this.searchDirection;
    }

    public Collection<Optimization> optimizations() {
        return this.optimizations;
    }

    public boolean optimizationEnabled(Optimization optimization) {
        return optimization.isOneOf(this.optimizations);
    }

    public boolean useDestinationPruning() {
        return this.optimizationEnabled(Optimization.PARETO_CHECK_AGAINST_DESTINATION);
    }

    public boolean runInParallel() {
        return this.optimizationEnabled(Optimization.PARALLEL);
    }

    public MultiCriteriaRequest<T> multiCriteria() {
        return this.multiCriteria;
    }

    public RaptorTimers performanceTimers() {
        return this.performanceTimers;
    }

    public DebugRequest debug() {
        return this.debug;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.profile, this.searchParams, this.multiCriteria, this.debug});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaptorRequest that = (RaptorRequest)o;
        return this.profile == that.profile && Objects.equals(this.searchParams, that.searchParams) && Objects.equals(this.multiCriteria, that.multiCriteria) && Objects.equals(this.debug, that.debug);
    }

    public String toString() {
        RaptorRequest<T> defaults = RaptorRequest.defaults();
        return ToStringBuilder.of(RaptorRequest.class).addEnum("profile", this.profile).addBoolIfTrue("reverse", this.searchDirection.isInReverse()).addCol("optimizations", this.optimizations).addObj("multiCriteria", this.multiCriteria, defaults.multiCriteria()).addObj("debug", this.debug, defaults.debug()).addObj("searchParams", this.searchParams).addBoolIfTrue("withPerformanceTimers", this.performanceTimers != RaptorTimers.NOOP).toString();
    }

    static <T extends RaptorTripSchedule> RaptorRequest<T> defaults() {
        return new RaptorRequest<T>();
    }

    static void assertProperty(boolean predicate, String message) {
        if (!predicate) {
            throw new IllegalArgumentException(message);
        }
    }

    private void verify() {
        this.searchParams.verify();
        if (!this.profile.is(RaptorProfile.MULTI_CRITERIA) && this.useDestinationPruning()) {
            LOG.warn("Destination pruning is only supported using McRangeRaptor");
        }
    }
}

