/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.util.stream.Stream;

public enum RaptorProfile {
    MULTI_CRITERIA("Mc", true),
    STANDARD("Standard", true),
    BEST_TIME("StdBestTime", false),
    MIN_TRAVEL_DURATION("MinTravelDuration", true);

    private final boolean supportsConstrainedTransfers;
    private final String abbreviation;

    private RaptorProfile(String abbreviation, boolean supportsConstrainedTransfers) {
        this.supportsConstrainedTransfers = supportsConstrainedTransfers;
        this.abbreviation = abbreviation;
    }

    public final String abbreviation() {
        return this.abbreviation;
    }

    public boolean supportsConstrainedTransfers() {
        return this.supportsConstrainedTransfers;
    }

    public boolean is(RaptorProfile candidate) {
        return this == candidate;
    }

    public boolean isOneOf(RaptorProfile ... candidates) {
        return Stream.of(candidates).anyMatch(this::is);
    }

    public boolean useApproximateTripSearch() {
        return this.is(MIN_TRAVEL_DURATION);
    }
}

