/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.model.GeneralizedCostRelaxFunction;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.model.RelaxFunction;
import org.opentripplanner.raptor.api.request.RaptorTransitPriorityGroupCalculator;

public class MultiCriteriaRequest<T extends RaptorTripSchedule> {
    private final RelaxFunction relaxC1;
    @Nullable
    private final RaptorTransitPriorityGroupCalculator transitPriorityCalculator;
    @Nullable
    private final Double relaxCostAtDestination;

    private MultiCriteriaRequest() {
        this.relaxC1 = RelaxFunction.NORMAL;
        this.transitPriorityCalculator = null;
        this.relaxCostAtDestination = null;
    }

    public MultiCriteriaRequest(Builder<T> builder) {
        this.relaxC1 = Objects.requireNonNull(builder.relaxC1());
        this.transitPriorityCalculator = builder.transitPriorityCalculator();
        this.relaxCostAtDestination = builder.relaxCostAtDestination();
    }

    public static <S extends RaptorTripSchedule> Builder<S> of() {
        return new Builder(new MultiCriteriaRequest());
    }

    public Builder<T> copyOf() {
        return new Builder(this);
    }

    public RelaxFunction relaxC1() {
        return this.relaxC1;
    }

    @Deprecated
    @Nullable
    public RelaxFunction relaxC1AtDestination() {
        return this.relaxC1.isNormal() ? this.relaxCostAtDestination().map(GeneralizedCostRelaxFunction::of).orElse(RelaxFunction.NORMAL) : this.relaxC1;
    }

    public Optional<RaptorTransitPriorityGroupCalculator> transitPriorityCalculator() {
        return Optional.ofNullable(this.transitPriorityCalculator);
    }

    @Deprecated
    public Optional<Double> relaxCostAtDestination() {
        return Optional.ofNullable(this.relaxCostAtDestination);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiCriteriaRequest that = (MultiCriteriaRequest)o;
        return Objects.equals(this.relaxC1, that.relaxC1) && Objects.equals(this.transitPriorityCalculator, that.transitPriorityCalculator) && Objects.equals(this.relaxCostAtDestination, that.relaxCostAtDestination);
    }

    public int hashCode() {
        return Objects.hash(this.relaxC1, this.transitPriorityCalculator, this.relaxCostAtDestination);
    }

    public String toString() {
        return ToStringBuilder.of(MultiCriteriaRequest.class).addObj("relaxC1", this.relaxC1, RelaxFunction.NORMAL).addObj("transitPriorityCalculator", this.transitPriorityCalculator).addNum("relaxCostAtDestination", this.relaxCostAtDestination).toString();
    }

    public static class Builder<T extends RaptorTripSchedule> {
        private final MultiCriteriaRequest<T> original;
        private RelaxFunction relaxC1;
        private RaptorTransitPriorityGroupCalculator transitPriorityCalculator = null;
        private Double relaxCostAtDestination = null;

        public Builder(MultiCriteriaRequest<T> original) {
            this.original = original;
            this.relaxC1 = original.relaxC1;
        }

        @Nullable
        public RelaxFunction relaxC1() {
            return this.relaxC1;
        }

        public Builder<T> withRelaxC1(RelaxFunction relaxC1) {
            this.relaxC1 = relaxC1;
            return this;
        }

        @Nullable
        public RaptorTransitPriorityGroupCalculator transitPriorityCalculator() {
            return this.transitPriorityCalculator;
        }

        public Builder<T> withTransitPriorityCalculator(RaptorTransitPriorityGroupCalculator value) {
            this.transitPriorityCalculator = value;
            return this;
        }

        @Nullable
        @Deprecated
        public Double relaxCostAtDestination() {
            return this.relaxCostAtDestination;
        }

        @Deprecated
        public Builder<T> withRelaxCostAtDestination(Double value) {
            this.relaxCostAtDestination = value;
            return this;
        }

        public MultiCriteriaRequest<T> build() {
            MultiCriteriaRequest newInstance = new MultiCriteriaRequest(this);
            return this.original.equals(newInstance) ? this.original : newInstance;
        }

        public String toString() {
            return ToStringBuilder.of(Builder.class).addObj("relaxC1", this.relaxC1).addObj("transitPriorityCalculator", this.transitPriorityCalculator).addNum("relaxCostAtDestination", this.relaxCostAtDestination).toString();
        }
    }
}

