/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.request;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.raptor.api.debug.DebugEvent;
import org.opentripplanner.raptor.api.debug.DebugLogger;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.api.view.ArrivalView;
import org.opentripplanner.raptor.api.view.PatternRideView;

public record DebugRequest(List<Integer> stops, List<Integer> path, int debugPathFromStopIndex, Consumer<DebugEvent<ArrivalView<?>>> stopArrivalListener, Consumer<DebugEvent<PatternRideView<?, ?>>> patternRideDebugListener, Consumer<DebugEvent<RaptorPath<?>>> pathFilteringListener, DebugLogger logger) {
    private static final DebugRequest DEFAULT_DEBUG_REQUEST = new DebugRequest(List.of(), List.of(), 0, null, null, null, DebugLogger.noop());

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugRequest that = (DebugRequest)o;
        return this.debugPathFromStopIndex == that.debugPathFromStopIndex && Objects.equals(this.stops, that.stops) && Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stops, this.path, this.debugPathFromStopIndex);
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(DebugRequest.class).addCol("stops", this.stops).addCol("path", this.path).addNum("startAtStopIndex", (Number)this.debugPathFromStopIndex, 0).addBoolIfTrue("stopArrivalListener", this.stopArrivalListener != null).addBoolIfTrue("pathFilteringListener", this.pathFilteringListener != null).addBoolIfTrue("logger", this.logger != DEFAULT_DEBUG_REQUEST.logger()).toString();
    }

    static DebugRequest defaults() {
        return DEFAULT_DEBUG_REQUEST;
    }
}

