/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.path;

import java.util.Objects;
import org.opentripplanner.raptor.api.model.RaptorConstrainedTransfer;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.PathLeg;

public final class TransitPathLeg<T extends RaptorTripSchedule>
implements PathLeg<T> {
    private final T trip;
    private final int boardTime;
    private final int alightTime;
    private final int boardStopPos;
    private final int alightStopPos;
    private final RaptorConstrainedTransfer constrainedTransferAfterLeg;
    private final int cost;
    private final PathLeg<T> next;
    private final int boardStop;
    private final int alightStop;

    public TransitPathLeg(T trip, int boardTime, int alightTime, int boardStopPos, int alightStopPos, RaptorConstrainedTransfer constrainedTransferAfterLeg, int cost, PathLeg<T> next) {
        this.trip = trip;
        this.boardTime = boardTime;
        this.alightTime = alightTime;
        this.boardStopPos = boardStopPos;
        this.alightStopPos = alightStopPos;
        this.constrainedTransferAfterLeg = constrainedTransferAfterLeg;
        this.cost = cost;
        this.next = next;
        this.boardStop = trip.pattern().stopIndex(boardStopPos);
        this.alightStop = trip.pattern().stopIndex(alightStopPos);
    }

    public T trip() {
        return this.trip;
    }

    public int getFromStopPosition() {
        return this.boardStopPos;
    }

    public int getToStopPosition() {
        return this.alightStopPos;
    }

    public RaptorConstrainedTransfer getConstrainedTransferAfterLeg() {
        return this.constrainedTransferAfterLeg;
    }

    @Override
    public int fromTime() {
        return this.boardTime;
    }

    @Override
    public int fromStop() {
        return this.boardStop;
    }

    @Override
    public int toTime() {
        return this.alightTime;
    }

    @Override
    public int toStop() {
        return this.alightStop;
    }

    @Override
    public int generalizedCost() {
        return this.cost;
    }

    @Override
    public boolean isTransitLeg() {
        return true;
    }

    @Override
    public PathLeg<T> nextLeg() {
        return this.next;
    }

    public boolean isStaySeatedOntoNextLeg() {
        return this.constrainedTransferAfterLeg != null && this.constrainedTransferAfterLeg.getTransferConstraint().isStaySeated();
    }

    public int hashCode() {
        return Objects.hash(this.boardTime, this.boardStopPos, this.alightTime, this.alightStopPos, this.trip, this.next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitPathLeg that = (TransitPathLeg)o;
        return this.boardTime == that.boardTime && this.boardStopPos == that.boardStopPos && this.alightTime == that.alightTime && this.alightStopPos == that.alightStopPos && this.trip.equals(that.trip) && this.next.equals(that.next);
    }

    public String toString() {
        return this.trip.pattern().debugInfo() + " " + this.asString(this.toStop());
    }
}

