/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.path;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.AccessPathLeg;
import org.opentripplanner.raptor.api.path.EgressPathLeg;
import org.opentripplanner.raptor.api.path.TransferPathLeg;
import org.opentripplanner.raptor.api.path.TransitPathLeg;

public interface PathLeg<T extends RaptorTripSchedule> {
    public int fromTime();

    default public int fromStop() {
        throw new IllegalStateException("Leg does not start fro a stop: " + this);
    }

    public int toTime();

    default public int toStop() {
        throw new IllegalStateException("Leg does not end at a stop: " + this);
    }

    default public int duration() {
        return this.toTime() - this.fromTime();
    }

    public int generalizedCost();

    default public int generalizedCostTotal() {
        if (this.generalizedCost() < 0) {
            return this.generalizedCost();
        }
        return this.stream().mapToInt(PathLeg::generalizedCost).sum();
    }

    default public boolean isAccessLeg() {
        return false;
    }

    default public AccessPathLeg<T> asAccessLeg() {
        return (AccessPathLeg)this;
    }

    default public boolean isTransitLeg() {
        return false;
    }

    default public TransitPathLeg<T> asTransitLeg() {
        return (TransitPathLeg)this;
    }

    default public boolean isTransferLeg() {
        return false;
    }

    default public TransferPathLeg<T> asTransferLeg() {
        return (TransferPathLeg)this;
    }

    default public boolean isEgressLeg() {
        return false;
    }

    default public EgressPathLeg<T> asEgressLeg() {
        return (EgressPathLeg)this;
    }

    public PathLeg<T> nextLeg();

    default public String asString(int toStop) {
        return this.asString() + " ~ " + toStop;
    }

    default public String asString() {
        return TimeUtils.timeToStrCompact(this.fromTime()) + "-" + TimeUtils.timeToStrCompact(this.toTime()) + "(" + DurationUtils.durationToStr(this.duration()) + ")";
    }

    @Nullable
    default public TransitPathLeg<T> nextTransitLeg() {
        PathLeg<T> leg = this.nextLeg();
        while (!leg.isEgressLeg()) {
            if (leg.isTransitLeg()) {
                return leg.asTransitLeg();
            }
            leg = leg.nextLeg();
        }
        return null;
    }

    default public Stream<PathLeg<T>> stream() {
        return StreamSupport.stream(this.iterator().spliterator(), false);
    }

    default public Iterable<PathLeg<T>> iterator() {
        return () -> new Iterator<PathLeg<T>>(){
            private PathLeg<T> currentLeg;
            {
                this.currentLeg = PathLeg.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentLeg != null;
            }

            @Override
            public PathLeg<T> next() {
                PathLeg temp = this.currentLeg;
                this.currentLeg = this.currentLeg.isEgressLeg() ? null : this.currentLeg.nextLeg();
                return temp;
            }
        };
    }
}

