/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.model;

import javax.annotation.Nullable;
import org.opentripplanner.framework.time.DurationUtils;

public interface RaptorAccessEgress {
    public int stop();

    public int generalizedCost();

    public int durationInSeconds();

    default public int earliestDepartureTime(int requestedDepartureTime) {
        return requestedDepartureTime;
    }

    default public int latestArrivalTime(int requestedArrivalTime) {
        return requestedArrivalTime;
    }

    public boolean hasOpeningHours();

    @Nullable
    public String openingHoursToString();

    default public int numberOfRides() {
        return 0;
    }

    default public boolean hasRides() {
        return this.numberOfRides() > 0;
    }

    default public boolean stopReachedOnBoard() {
        return false;
    }

    default public boolean stopReachedByWalking() {
        return !this.stopReachedOnBoard();
    }

    default public boolean isFree() {
        return this.durationInSeconds() == 0;
    }

    default public String asString(boolean includeStop) {
        StringBuilder buf = new StringBuilder();
        if (this.isFree()) {
            buf.append("Free");
        } else if (this.hasRides()) {
            buf.append(this.stopReachedOnBoard() ? "Flex" : "Flex+Walk");
        } else {
            buf.append("Walk");
        }
        buf.append(' ').append(DurationUtils.durationToStr(this.durationInSeconds()));
        if (this.hasRides()) {
            buf.append(' ').append(this.numberOfRides()).append('x');
        }
        if (this.hasOpeningHours()) {
            buf.append(' ').append(this.openingHoursToString());
        }
        if (includeStop) {
            buf.append(" ~ ").append(this.stop());
        }
        return buf.toString();
    }
}

