/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor.api.debug;

import org.opentripplanner.framework.tostring.ToStringBuilder;

public class DebugEvent<E> {
    private final Action action;
    private final int iterationStartTime;
    private final E element;
    private final E rejectedDroppedByElement;
    private final String reason;

    private DebugEvent(Action action, int iterationStartTime, E element, E rejectedDroppedByElement, String reason) {
        this.action = action;
        this.iterationStartTime = iterationStartTime;
        this.element = element;
        this.rejectedDroppedByElement = rejectedDroppedByElement;
        this.reason = reason;
    }

    public static <E> DebugEvent<E> accept(int iterationStartTime, E element) {
        return new DebugEvent<Object>(Action.ACCEPT, iterationStartTime, element, null, null);
    }

    public static <E> DebugEvent<E> reject(int iterationStartTime, E element, E rejectedByElement, String reason) {
        return new DebugEvent<E>(Action.REJECT, iterationStartTime, element, rejectedByElement, reason);
    }

    public static <E> DebugEvent<E> drop(int iterationStartTime, E element, E droppedByElement, String reason) {
        return new DebugEvent<E>(Action.DROP, iterationStartTime, element, droppedByElement, reason);
    }

    public Action action() {
        return this.action;
    }

    public int iterationStartTime() {
        return this.iterationStartTime;
    }

    public E element() {
        return this.element;
    }

    public E rejectedDroppedByElement() {
        return this.rejectedDroppedByElement;
    }

    public String reason() {
        return this.reason == null ? "" : this.reason;
    }

    public String toString() {
        return ToStringBuilder.of(DebugEvent.class).addEnum("action", this.action).addServiceTime("iterationStartTime", this.iterationStartTime).addObj("element", this.element).addObj("rejectedDroppedByElement", this.rejectedDroppedByElement).addStr("reason", this.reason).toString();
    }

    public static enum Action {
        ACCEPT("Accept"),
        REJECT("Reject"),
        DROP("Drop");

        private final String description;

        private Action(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

