/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.raptor;

import java.util.stream.Collectors;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.request.RaptorRequest;
import org.opentripplanner.raptor.api.response.RaptorResponse;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorker;
import org.opentripplanner.raptor.rangeraptor.internalapi.RaptorWorkerResult;
import org.opentripplanner.raptor.service.DefaultStopArrivals;
import org.opentripplanner.raptor.service.HeuristicSearchTask;
import org.opentripplanner.raptor.service.RangeRaptorDynamicSearch;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaptorService<T extends RaptorTripSchedule> {
    private static final Logger LOG = LoggerFactory.getLogger(RaptorService.class);
    private final RaptorConfig<T> config;

    public RaptorService(RaptorConfig<T> config) {
        this.config = config;
    }

    public RaptorResponse<T> route(RaptorRequest<T> request, RaptorTransitDataProvider<T> transitData) {
        LOG.debug("Original request: {}", request);
        RaptorResponse<T> response = request.isDynamicSearch() ? new RangeRaptorDynamicSearch<T>(this.config, transitData, request).route() : this.routeUsingStdWorker(transitData, request);
        if (LOG.isDebugEnabled()) {
            String pathsAsText = response.paths().stream().map(p -> "\t\n" + p.toString(transitData.stopNameResolver())).collect(Collectors.joining());
            LOG.debug("Result: {}", (Object)pathsAsText);
        }
        return response;
    }

    public void compareHeuristics(RaptorRequest<T> r1, RaptorRequest<T> r2, RaptorTransitDataProvider<T> transitData) {
        HeuristicSearchTask<T> fwdHeur = new HeuristicSearchTask<T>(r1, this.config, transitData);
        HeuristicSearchTask<T> revHeur = new HeuristicSearchTask<T>(r2, this.config, transitData);
        fwdHeur.forceRun();
        revHeur.forceRun();
        fwdHeur.debugCompareResult(revHeur);
    }

    private RaptorResponse<T> routeUsingStdWorker(RaptorTransitDataProvider<T> transitData, RaptorRequest<T> request) {
        RaptorWorker<T> worker = this.config.createStdWorker(transitData, request);
        RaptorWorkerResult<T> result = worker.route();
        DefaultStopArrivals arrivals = new DefaultStopArrivals(result);
        return new RaptorResponse<T>(result.extractPaths(), arrivals, request, request);
    }
}

