/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty.specifier;

import java.util.Arrays;
import java.util.List;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.wayproperty.specifier.Condition;
import org.opentripplanner.openstreetmap.wayproperty.specifier.OsmSpecifier;

public class ExactMatchSpecifier
implements OsmSpecifier {
    public static final int MATCH_MULTIPLIER = 200;
    public static final int NO_MATCH_SCORE = 0;
    private final List<Condition> conditions;
    private final int bestMatchScore;

    public ExactMatchSpecifier(String spec) {
        this(OsmSpecifier.parseConditions(spec, ";"));
    }

    public ExactMatchSpecifier(Condition ... conditions) {
        this.conditions = Arrays.asList(conditions);
        this.bestMatchScore = this.conditions.size() * 200;
    }

    @Override
    public OsmSpecifier.Scores matchScores(OSMWithTags way) {
        return new OsmSpecifier.Scores(this.allForwardTagsMatch(way) ? this.bestMatchScore : 0, this.allBackwardTagsMatch(way) ? this.bestMatchScore : 0);
    }

    @Override
    public int matchScore(OSMWithTags way) {
        if (this.allTagsMatch(way)) {
            return this.bestMatchScore;
        }
        return 0;
    }

    public boolean allTagsMatch(OSMWithTags way) {
        return this.conditions.stream().allMatch(o -> o.isMatch(way));
    }

    public boolean allBackwardTagsMatch(OSMWithTags way) {
        return this.conditions.stream().allMatch(c -> c.isBackwardMatch(way));
    }

    public boolean allForwardTagsMatch(OSMWithTags way) {
        return this.conditions.stream().allMatch(c -> c.isForwardMatch(way));
    }

    public static ExactMatchSpecifier exact(String spec) {
        return new ExactMatchSpecifier(spec);
    }
}

