/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty.specifier;

import java.util.Arrays;
import java.util.OptionalInt;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Condition {
    public String key();

    default public MatchResult matchType() {
        return MatchResult.EXACT;
    }

    public boolean isExtendedKeyMatch(OSMWithTags var1, String var2);

    default public boolean isMatch(OSMWithTags way) {
        return this.isExtendedKeyMatch(way, this.key());
    }

    default public MatchResult match(OSMWithTags way) {
        return this.isMatch(way) ? this.matchType() : MatchResult.NONE;
    }

    default public boolean isLeftMatch(OSMWithTags way) {
        String leftKey = this.key() + ":left";
        if (way.hasTag(leftKey)) {
            return this.isExtendedKeyMatch(way, leftKey);
        }
        return this.isExplicitBothMatch(way);
    }

    default public boolean isRightMatch(OSMWithTags way) {
        String rightKey = this.key() + ":right";
        if (way.hasTag(rightKey)) {
            return this.isExtendedKeyMatch(way, rightKey);
        }
        return this.isExplicitBothMatch(way);
    }

    default public boolean isExplicitBothMatch(OSMWithTags way) {
        String bothKey = this.key() + ":both";
        if (way.hasTag(bothKey)) {
            return this.isExtendedKeyMatch(way, bothKey);
        }
        return this.isMatch(way);
    }

    default public boolean isForwardMatch(OSMWithTags way) {
        String forwardKey = this.key() + ":forward";
        if (way.hasTag(forwardKey)) {
            return this.isExtendedKeyMatch(way, forwardKey);
        }
        return this.isRightMatch(way);
    }

    default public MatchResult matchForward(OSMWithTags way) {
        return this.isForwardMatch(way) ? this.matchType() : MatchResult.NONE;
    }

    default public boolean isBackwardMatch(OSMWithTags way) {
        String backwardKey = this.key() + ":backward";
        if (way.hasTag(backwardKey)) {
            return this.isExtendedKeyMatch(way, backwardKey);
        }
        return this.isLeftMatch(way);
    }

    default public MatchResult matchBackward(OSMWithTags way) {
        return this.isBackwardMatch(way) ? this.matchType() : MatchResult.NONE;
    }

    public static enum MatchResult {
        EXACT,
        WILDCARD,
        NONE;

    }

    public record EqualsAnyInOrAbsent(String key, String[] values) implements Condition
    {
        public EqualsAnyInOrAbsent(String key) {
            this(key, "no", "none");
        }

        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            return !way.hasTag(exKey) || Arrays.stream(this.values).anyMatch(value -> way.matchesKeyValue(exKey, (String)value));
        }
    }

    public record EqualsAnyIn(String key, String[] values) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            return Arrays.stream(this.values).anyMatch(value -> way.matchesKeyValue(exKey, (String)value));
        }
    }

    public record InclusiveRange(String key, int upper, int lower) implements Condition
    {
        public InclusiveRange {
            if (upper < lower) {
                throw new IllegalArgumentException("Upper bound is lower than lower bound");
            }
        }

        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            OptionalInt maybeInt = way.getTagAsInt(exKey, ignored -> {});
            return maybeInt.isPresent() && maybeInt.getAsInt() >= this.lower && maybeInt.getAsInt() <= this.upper;
        }
    }

    public record LessThan(String key, int value) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            OptionalInt maybeInt = way.getTagAsInt(exKey, ignored -> {});
            return maybeInt.isPresent() && maybeInt.getAsInt() < this.value;
        }
    }

    public record GreaterThan(String key, int value) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            OptionalInt maybeInt = way.getTagAsInt(exKey, ignored -> {});
            return maybeInt.isPresent() && maybeInt.getAsInt() > this.value;
        }
    }

    public record Absent(String key) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            return !way.hasTag(exKey);
        }
    }

    public record Present(String key) implements Condition
    {
        @Override
        public MatchResult matchType() {
            return MatchResult.WILDCARD;
        }

        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            return way.hasTag(exKey);
        }
    }

    public record Equals(String key, String value) implements Condition
    {
        @Override
        public boolean isExtendedKeyMatch(OSMWithTags way, String exKey) {
            return way.hasTag(exKey) && way.matchesKeyValue(exKey, this.value);
        }
    }
}

